/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.nongnu.pulsefire.device.ui.JPanelConsole;
import org.nongnu.pulsefire.device.ui.JPanelConsoleInfo;
import org.nongnu.pulsefire.device.ui.JTopPanelSerial;
import org.nongnu.pulsefire.device.ui.JTopPanelStatus;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;
import org.nongnu.pulsefire.device.ui.tabs.JFireTabPanel;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelCit;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelGraphs;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelInput;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelLpm;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelMal;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPins;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPtc;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPtt;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPwm;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelPwmExt;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelScope;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelSettings;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelStv;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelSystem;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelUILog;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelVariables;
import org.nongnu.pulsefire.device.ui.tabs.JTabPanelVfc;

public class JMainPanel
extends JPanel
implements PulseFireUISettingListener {
    private static final long serialVersionUID = -9173866662540287337L;
    public List<JFireTabPanel> tabPanels = new ArrayList<JFireTabPanel>(10);
    public JTabbedPane tabbedPane = null;
    public JSplitPane bottomSplitPane = null;
    public JSplitPane bottomLogSplitPane = null;
    public AbstractFireTabPanel uiLogPanel = null;
    public AbstractFireTabPanel scopePanel = null;
    public JTopPanelSerial topPanelSerial = null;

    public JMainPanel() {
        this.tabPanels.add(new JTabPanelPwm());
        this.tabPanels.add(new JTabPanelPwmExt());
        this.tabPanels.add(new JTabPanelSystem());
        this.tabPanels.add(new JTabPanelPins());
        this.tabPanels.add(new JTabPanelInput());
        this.tabPanels.add(new JTabPanelCit());
        this.tabPanels.add(new JTabPanelStv());
        this.tabPanels.add(new JTabPanelPtc());
        this.tabPanels.add(new JTabPanelPtt());
        this.tabPanels.add(new JTabPanelVfc());
        this.tabPanels.add(new JTabPanelMal());
        this.tabPanels.add(new JTabPanelLpm());
        this.tabPanels.add(new JTabPanelGraphs());
        this.tabPanels.add(new JTabPanelVariables());
        this.tabPanels.add(new JTabPanelSettings());
        if (PulseFireUI.getInstance().getSettingsManager().getSettingBoolean(PulseFireUISettingKeys.TAB_UILOG_ENABLE).booleanValue()) {
            this.uiLogPanel = new JTabPanelUILog();
            this.tabPanels.add(this.uiLogPanel);
        }
        if (PulseFireUI.getInstance().getSettingsManager().getSettingBoolean(PulseFireUISettingKeys.TAB_SCOPE_ENABLE).booleanValue()) {
            this.scopePanel = new JTabPanelScope();
            this.tabPanels.add(this.scopePanel);
        }
        JMainPanel main = this;
        main.setLayout(new BorderLayout());
        main.add((Component)this.createTop(), "First");
        main.add((Component)this.createContentSplit(), "Center");
        PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.TAB_UILOG_ENABLE, this);
        PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.TAB_SCOPE_ENABLE, this);
    }

    private JPanel createTop() {
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(1, 2));
        this.topPanelSerial = new JTopPanelSerial();
        top.add(this.topPanelSerial);
        top.add(new JTopPanelStatus());
        return top;
    }

    private JSplitPane createContentSplit() {
        JPanel sp0 = this.createCenterContent();
        JSplitPane sp1 = this.createBottomSplit();
        this.bottomSplitPane = new JSplitPane(0, sp0, sp1);
        this.bottomSplitPane.setOneTouchExpandable(true);
        this.bottomSplitPane.setResizeWeight(0.7);
        this.bottomSplitPane.setDividerLocation(PulseFireUI.getInstance().getSettingsManager().getSettingInteger(PulseFireUISettingKeys.UI_SPLIT_BOTTOM));
        sp0.setMinimumSize(new Dimension(100, 350));
        sp1.setMinimumSize(new Dimension(200, 150));
        return this.bottomSplitPane;
    }

    private JSplitPane createBottomSplit() {
        JPanel sp0 = this.createBottomConsole();
        JPanel sp1 = this.createBottomInfo();
        this.bottomLogSplitPane = new JSplitPane(1, sp0, sp1);
        this.bottomLogSplitPane.setOneTouchExpandable(true);
        this.bottomLogSplitPane.setResizeWeight(0.4);
        this.bottomLogSplitPane.setDividerLocation(PulseFireUI.getInstance().getSettingsManager().getSettingInteger(PulseFireUISettingKeys.UI_SPLIT_BOTTOM_LOG));
        sp0.setMinimumSize(new Dimension(200, 100));
        sp1.setMinimumSize(new Dimension(200, 100));
        return this.bottomLogSplitPane;
    }

    private JPanel createCenterContent() {
        JPanel center = new JPanel();
        center.setLayout(new GridLayout(1, 0));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(UIManager.getFont("TabbedPane.font"));
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        for (JFireTabPanel panel : this.tabPanels) {
            JScrollPane scrollPane = new JScrollPane(panel.getJPanel());
            scrollPane.setHorizontalScrollBarPolicy(32);
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            panel.setParentScrollPane(scrollPane);
            this.tabbedPane.addTab(panel.getTabName(), panel.getTabIcon(), scrollPane, panel.getTabTooltip());
        }
        center.add(this.tabbedPane);
        return center;
    }

    private JPanel createBottomConsole() {
        return new JPanelConsole();
    }

    private JPanel createBottomInfo() {
        return new JPanelConsoleInfo();
    }

    @Override
    public void settingUpdated(PulseFireUISettingKeys key, String value) {
        if (PulseFireUISettingKeys.TAB_SCOPE_ENABLE == key) {
            if (PulseFireUI.getInstance().getSettingsManager().getSettingBoolean(key).booleanValue()) {
                if (this.scopePanel == null) {
                    this.scopePanel = new JTabPanelScope();
                    JScrollPane scrollPane = new JScrollPane(this.scopePanel.getJPanel());
                    scrollPane.setHorizontalScrollBarPolicy(32);
                    scrollPane.setVerticalScrollBarPolicy(22);
                    scrollPane.setBorder(BorderFactory.createEmptyBorder());
                    this.scopePanel.setParentScrollPane(scrollPane);
                    this.tabbedPane.addTab(this.scopePanel.getTabName(), this.scopePanel.getTabIcon(), scrollPane, this.scopePanel.getTabTooltip());
                }
            } else if (this.scopePanel != null) {
                this.removeTabPanel(this.scopePanel);
                this.scopePanel.release();
                this.scopePanel = null;
            }
        } else if (PulseFireUISettingKeys.TAB_UILOG_ENABLE == key) {
            if (PulseFireUI.getInstance().getSettingsManager().getSettingBoolean(key).booleanValue()) {
                if (this.uiLogPanel == null) {
                    this.uiLogPanel = new JTabPanelUILog();
                    JScrollPane scrollPane = new JScrollPane(this.uiLogPanel.getJPanel());
                    scrollPane.setHorizontalScrollBarPolicy(32);
                    scrollPane.setVerticalScrollBarPolicy(22);
                    scrollPane.setBorder(BorderFactory.createEmptyBorder());
                    this.uiLogPanel.setParentScrollPane(scrollPane);
                    this.tabbedPane.addTab(this.uiLogPanel.getTabName(), this.uiLogPanel.getTabIcon(), scrollPane, this.uiLogPanel.getTabTooltip());
                }
            } else if (this.uiLogPanel != null) {
                this.removeTabPanel(this.uiLogPanel);
                this.uiLogPanel.release();
                this.uiLogPanel = null;
            }
        }
    }

    private void removeTabPanel(JFireTabPanel panel) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component tab = this.tabbedPane.getComponentAt(i);
            if (panel.getParentScrollPane() != tab) continue;
            this.tabbedPane.removeTabAt(i);
            break;
        }
    }
}

