/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JCommandButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = -5019912933607846942L;
    private Command command = null;

    public JCommandButton(CommandName commandName) {
        this(commandName, null);
    }

    public JCommandButton(CommandName commandName, Integer index) {
        if (commandName == null) {
            throw new NullPointerException("Can't make command button with null command name.");
        }
        this.setName("commandname." + commandName.name() + ".button");
        this.command = new Command(commandName);
        if (index != null) {
            this.command.setArgu0(index.toString());
            this.setName("commandname." + commandName.name() + index + ".button");
        }
        this.setText(PulseFireUI.getInstance().getContext().getResourceMap().getString(this.getName() + ".text", new Object[0]));
        this.addActionListener(this);
        JComponentEnableStateListener.attach(this, commandName);
    }

    public JCommandButton(CommandName commandName, CommandName argument, Integer index) {
        this.setName("commandname." + argument.name() + ".button");
        this.command = new Command(commandName);
        this.command.setArgu0(argument.name());
        if (index != null) {
            this.command.setArgu1(index.toString());
            this.setName("commandname." + argument.name() + index + ".button");
        }
        this.setText(PulseFireUI.getInstance().getContext().getResourceMap().getString(this.getName() + ".text", new Object[0]));
        this.addActionListener(this);
        JComponentEnableStateListener.attach(this, argument);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PulseFireUI.getInstance().getDeviceManager().requestCommand(this.command);
    }
}

