/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;

public class JNimbusColorFrame
extends JFrame {
    private static final long serialVersionUID = 5416437245805376356L;
    private Logger logger = null;
    private JFrame[] colorFrames = null;
    private static List<String> NIMBUS_PRIMARY_COLORS = Arrays.asList("text", "control", "nimbusBase", "nimbusOrange", "nimbusGreen", "nimbusRed", "nimbusInfoBlue", "nimbusAlertYellow", "nimbusFocus", "nimbusSelectedText", "nimbusSelectionBackground", "nimbusDisabledText", "nimbusLightBackground", "info");
    private static List<String> NIMBUS_SECONDARY_COLORS = Arrays.asList("textForeground", "textBackground", "background", "nimbusBlueGrey", "nimbusBorder", "nimbusSelection", "infoText", "menuText", "menu", "scrollbar", "controlText", "controlHighlight", "controlLHighlight", "controlShadow", "controlDkShadow", "textHighlight", "textHighlightText", "textInactiveText", "desktop", "activeCaption", "inactiveCaption");
    private List<ColorModel> models = new ArrayList<ColorModel>(100);

    public JNimbusColorFrame(JFrame mainFrame) {
        this.logger = Logger.getLogger(JNimbusColorFrame.class.getName());
        this.colorFrames = new JFrame[2];
        this.colorFrames[0] = this;
        this.colorFrames[1] = mainFrame;
        this.setTitle("PulseFire Colors");
        this.setMinimumSize(new Dimension(600, 400));
        this.setSize(this.getMinimumSize());
        this.setDefaultCloseOperation(2);
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        main.add((Component)this.createTop(), "First");
        main.add((Component)this.createCenter(), "Center");
        JScrollPane scroll = new JScrollPane(main);
        this.add(scroll);
    }

    public JPanel createTop() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Core Colors"));
        panel.setLayout(new SpringLayout());
        for (String colorName : NIMBUS_PRIMARY_COLORS) {
            this.addColorSetting(panel, colorName, true);
        }
        SpringLayoutGrid.makeCompactGrid(panel, NIMBUS_PRIMARY_COLORS.size(), 6);
        return panel;
    }

    public JPanel createCenter() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Colors"));
        panel.setLayout(new SpringLayout());
        for (String colorName : NIMBUS_SECONDARY_COLORS) {
            this.addColorSetting(panel, colorName, false);
        }
        SpringLayoutGrid.makeCompactGrid(panel, NIMBUS_SECONDARY_COLORS.size(), 6);
        return panel;
    }

    private void addColorSetting(JPanel panel, String colorName, boolean isPrimary) {
        final ColorSetting cs = new ColorSetting();
        cs.colorName = colorName;
        panel.add(new JLabel(colorName));
        JButton colorLabel = new JButton("   "){
            private static final long serialVersionUID = -1022540334405897683L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor((Color)this.getClientProperty("showColor"));
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            }
        };
        colorLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = (Color)((JButton)e.getSource()).getClientProperty("showColor");
                Color cNew = JColorChooser.showDialog(((Component)e.getSource()).getParent(), "Choose Color", c);
                ((JButton)e.getSource()).putClientProperty("showColor", cNew);
                ((JButton)e.getSource()).repaint();
                cs.setColor(cNew);
                for (ColorModel cm : JNimbusColorFrame.this.models) {
                    cm.dataChanged();
                }
            }
        });
        colorLabel.putClientProperty("showColor", cs.getColor());
        colorLabel.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        panel.add(colorLabel);
        cs.preview = colorLabel;
        for (int i = 0; i < 4; ++i) {
            JSpinner spinner = new JSpinner(new ColorModel(cs, i));
            spinner.setEditor(new JSpinner.NumberEditor(spinner));
            panel.add(spinner);
        }
    }

    class ColorSetting {
        String colorName = null;
        JButton preview = null;
        ColorModel colorModel = null;

        ColorSetting() {
        }

        public Color getColor() {
            return UIManager.getColor(this.colorName);
        }

        public void setColor(Color c) {
            UIManager.put(this.colorName, c);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (JFrame frame : JNimbusColorFrame.this.colorFrames) {
                        SwingUtilities.updateComponentTreeUI(frame);
                    }
                    try {
                        UIManager.setLookAndFeel(UIManager.getLookAndFeel().getClass().getName());
                    }
                    catch (Exception lafException) {
                        JNimbusColorFrame.this.logger.log(Level.WARNING, lafException.getMessage(), lafException);
                    }
                }
            });
        }
    }

    class ColorModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = -8007038375574192155L;
        ColorSetting colorSetting = null;
        int t = 0;

        public ColorModel(ColorSetting colorSetting, int t) {
            this.colorSetting = colorSetting;
            this.t = t;
            JNimbusColorFrame.this.models.add(this);
        }

        public void dataChanged() {
            this.fireStateChanged();
        }

        @Override
        public Object getNextValue() {
            int v = (Integer)this.getValue();
            if (v == 254) {
                return null;
            }
            return ++v;
        }

        @Override
        public Object getPreviousValue() {
            int v = (Integer)this.getValue();
            if (v == 0) {
                return null;
            }
            return --v;
        }

        @Override
        public Object getValue() {
            Color c = this.colorSetting.getColor();
            switch (this.t) {
                default: {
                    return c.getRed();
                }
                case 1: {
                    return c.getGreen();
                }
                case 2: {
                    return c.getBlue();
                }
                case 3: 
            }
            return c.getAlpha();
        }

        @Override
        public void setValue(Object value) {
            int v = (Integer)value;
            Color c = this.colorSetting.getColor();
            Color cNew = null;
            switch (this.t) {
                default: {
                    cNew = new Color(v, c.getBlue(), c.getGreen(), c.getAlpha());
                    break;
                }
                case 1: {
                    cNew = new Color(c.getRed(), v, c.getGreen(), c.getAlpha());
                    break;
                }
                case 2: {
                    cNew = new Color(c.getRed(), c.getBlue(), v, c.getAlpha());
                    break;
                }
                case 3: {
                    cNew = new Color(c.getRed(), c.getBlue(), c.getGreen(), v);
                }
            }
            this.colorSetting.setColor(cNew);
            this.colorSetting.preview.putClientProperty("showColor", cNew);
            this.colorSetting.preview.repaint();
            this.fireStateChanged();
        }
    }
}

