# pygsear
# Copyright (C) 2003 Lee Harr
#
#
# This file is part of pygsear.
#
# pygsear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# pygsear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with pygsear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#import random

#from pygsear.Game import Game
from pygsear.Drawable import Multi
#from pygsear.Event import KEY_Event
#from pygsear.Util import color
from pygsear import conf

import Shape
from conf import *


class NBoard(Multi):
    def __init__(self):
        Multi.__init__(self)
        board = []
        for row in range(ROWS):
            emptyrow = [0] * COLS
            board.append(emptyrow)
        self.board = board
        self.rows_removed = 0
        self.level = 0

    def row_empty(self, row):
        if row < 0 or row >= ROWS:
            raise IndexError
        if self.board[row].count(0) < COLS:
            return False

        return True

    def row_full(self, row):
        if row < 0 or row >= ROWS:
            raise IndexError
        if not self.board[row].count(0):
            return True

        return False

    def remove_row(self, r):
        self.board.append(self.board.pop(r))


    def remove_full_rows(self):
        remove_rows = []
        for rcount, r in enumerate(self.board):
            if self.row_full(rcount):
                for sprite in r:
                    sprite.kill()

                r[:] = ([0]*COLS)[:]

                remove_rows.append(rcount)

        remove_rows.sort()
        for rcount, r in enumerate(remove_rows):
            self.remove_row(r-rcount)
            self.rows_removed += 1

        self.align()

        return len(remove_rows)

    def align(self):
        for rcount, r in enumerate(self.board):
            for ccount, b in enumerate(r):
                try:
                    if b:
                        x = ccount
                        y = rcount

                        bx = x*SIZE
                        by = -(y+1)*SIZE

                        b.path.xOffset = bx
                        b.path.yOffset = by

                except IndexError:
                    pass

    def fall_ok(self, row, rcs):
        if row < 0:
            return False

        for rcount, r in enumerate(rcs):
            for ccount, c in enumerate(r):
                try:
                    #print 'check', row, c, rcount, ccount
                    if c and self.board[row+rcount][ccount]:
                        #print 'b', self.board[row+rcount][ccount]
                        return False
                except IndexError:
                    pass
        return True

    def freeze_piece(self, piece, row, rcs):
        c = piece.color
        piece_size = 0
        for rcount, r in enumerate(rcs):
            for ccount, col in enumerate(r):
                try:
                    #print row, rcount, ccount
                    if col:
                        piece_size += 1

                        x = ccount
                        y = row + rcount + 1

                        bx = x*SIZE
                        by = -(y+1)*SIZE

                        b = Shape.NBlock(c)
                        self.addSprite(b, xOffset=bx, yOffset=by)
                        conf.game.sprites.add(b)

                        self.board[y][x] = b

                except IndexError:
                    pass

        return piece_size
