package functions;

#   Rebot 0.10: Bot para aventuras de texto por red
#   Mdulo de funciones (versin 0.10)
#   http://aventuras.presi.org/rebot
#   (C) 2005-2007 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License 
#   along with this program.  If not, see <http://www.gnu.org/licenses/>. 

# Misc functions


# Elimina caracteres acentuados
# elimac(cadena) devuelve $cadena

sub elimac
{
  my $cad=$_[0];

  $cad=~tr//a/;
  $cad=~tr//e/;
  $cad=~tr//i/;
  $cad=~tr//o/;
  $cad=~tr//u/;
  $cad=~tr//n/;
  $cad=~tr//c/;

  return $cad;
}


# Devuelve true si el elemento est en la lista
# esta_en(elemento,\@lista)

sub esta_en
{ 
  my $item=$_[0];
  my $list=$_[1];

  foreach my $x (@$list) { if ($x eq $item) { return 1; } } 
}


# Como push() pero funciona con un array en hash
# aunque solo permite aadir un solo elemento
# mypush(@array{index},elemento)

sub mypush
{
  my $arr=$_[0];
  my $valor=$_[1];

  @$arr[++$#{\@$arr}]=$valor;
}


# Elimina cierto elemento de un array
# elimarr(\@array,elemento)

sub elimarr
{
  my $arr=$_[0];
  my $valor=$_[1];
  my $mover=0,$i=0;

  foreach my $x (@$arr)
  {
    if ($mover) { @$arr[$i++]=$x; next; }
    if ($x eq $valor) { $mover=1; next; }
    $i++;
  }
  if ($mover) { $#{\@$arr}--; }
  return $mover;
}


# Corta un texto por palabras segn una anchura determinada
# (c) 2001, Arthur Corliss <corliss-digitalmages.com> (GPLed)
# from Curses::Widgets.pm

sub textwrap {
  my $text = shift;
  my $columns = shift || 72;
  my (@tmp, @rv, $p);

  # Early exit if no text was passed
  return unless (defined $text && length($text));

  # Split the text into paragraphs, but preserve the terminating newline
  @tmp = split(/\n/, $text);
  foreach (@tmp) { $_ .= "\n" };
  chomp($tmp[$#tmp]) unless $text =~ /\n$/;

  # Split each paragraph into lines, according to whitespace
  for $p (@tmp) {

    # Snag lines that meet column limits (not counting newlines
    # as a character)
    if (length($p) <= $columns || (length($p) - 1 <= $columns &&
      $p =~ /\n$/s)) {
      push(@rv, $p);
      next;
    }

    # Split the line
    while (length($p) > $columns) {
      if (substr($p, 0, $columns) =~ /^(.+\s)(\S+)$/) {
        push(@rv, $1);
        $p = $2 . substr($p, $columns);
      } else {
        push(@rv, substr($p, 0, $columns));
        substr($p, 0, $columns) = '';
      }
    }
    push(@rv, $p);
  }

  if ($text =~ /\S\n(\n+)/) {
    $p = length($1);
    foreach (1..$p) { push(@rv, "\n") };
  }

  return @rv;
}

1;
