package irc;

#   Rebot 0.7 (beta): Bot para aventuras de texto por red
#   Mdulo de protocolo IRC
#   http://aventuras.presi.org/rebot
#   (C) 2005 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#   http://www.gnu.org/licenses/gpl.html

use Net::IRC;
use irc_conf;

$n_nick=0;

# Funciones requeridas de la interfaz comn de conexin

sub texto_inicial
{
  return 'Mdulo de protocolo IRC versin 0.7 (beta) para rebot';
}

sub texto_ayuda
{
  return
'  canal <canal>|ninguno
     Cambia el canal de IRC en el que rebot est.';
}

sub configurar
{
    $irc=new Net::IRC;

    $conexion=$irc->newconn
    (
      Server   => $irc_conf::servidor,
      Port     => $irc_conf::puerto,
      Nick     => $irc_conf::nick,
      Ircname  => $irc_conf::ircname,
      Username => $irc_conf::username
    );

    $conexion->{channel}=$irc_conf::canal;
    $conexion->add_handler('376', \&irc_on_connect);
    $conexion->add_handler('public', \&irc_on_public);
    $conexion->add_handler('msg', \&irc_on_msg);
    $conexion->add_handler('nicknameinuse', \&irc_on_nicknameinuse);
}

sub conectar
{
   log::eslog("irc: Conectando a $irc_conf::nick".'@'."$irc_conf::servidor:$irc_conf::puerto");
   $irc->start();
   log::eslog('irc: Desconectado');
}

sub enviar_mensaje   # Separa un texto en lneas y lo enva introduciendo un retardo para evitar el flood
{
   my $texto=$_[1];
   my $donde=$_[2];
   my @lineas=split("\n",$texto);
   my $len=@lineas;
   for ($i=0; $i<$len; $i++)
    {
      irc_enviar_mensaje($lineas[$i],$donde);
      sleep $irc_conf::retardo;
    }
}


sub comando
{
  my @elem=@_;
  my $quien=$elem[1];
  my $comando=$elem[2];
  my $canal=$elem[3];

  if ($comando eq 'canal')
  {
    if ($canal eq 'ninguno')
    {
       irc_salir_canal($conexion,$quien);
    }
    elsif (substr($canal,0,1) eq '#')
    {
       my $canal_ant=$conexion->{channel};
       irc_salir_canal($conexion,$quien);
       $conexion->{channel}=$canal;
       irc_entrar_canal($conexion,$quien,$canal_ant);
    }
    else { enviar_mensaje('irc','Todo canal empieza por #',$quien); }
  }
  else { return 0; }
  return 1;
}

# Funciones privadas especficas de irc


BEGIN
{

sub irc_on_connect 
{
   my $conexion=$_[0];
   log::eslog('irc: Conectado');
   if (substr($conexion->{channel},0,1) eq '#') { irc_entrar_canal($conexion); }
   enviar_mensaje('irc',$main::texto_inicial);
   enviar_mensaje('irc',irc::texto_inicial());
   main::modo('comando');
   $conexion->{connected}=1;
}

sub irc_on_public
{
   my ($conexion, $eventos) = @_;
   my $texto=$eventos->{args}[0];  # texto del canal
   main::tratar_texto($texto);
}

sub irc_on_msg
{  
   my ($conexion, $eventos) = @_;
   my $texto=$eventos->{args}[0];  # texto del privado
   my $quien=$eventos->nick;
   main::tratar_texto($texto,$quien);
}

sub irc_on_nicknameinuse
{
  my ($conexion, $eventos) = @_;
  my $viejo_nick;

  if ($n_nick)
    { $viejo_nick="$irc_conf::nick$n_nick"; }
  else
    { $viejo_nick=$irc_conf::nick; }
  $n_nick++;
  my $nuevo_nick="$irc_conf::nick$n_nick";
  $conexion->nick($nuevo_nick);
  log::eslog("irc: Nick '$viejo_nick' en uso, cambiado a '$nuevo_nick'");
}

sub irc_enviar_mensaje
{
   my $texto=$_[0];
   my $quien=$_[1];

   if ($quien eq '') { $quien=$conexion->{channel}; };

   $conexion->privmsg($quien,$texto);
}

sub irc_entrar_canal
{
   my $conexion=$_[0];
   my $quien=$_[1];
   my $canal_ant=$_[2];

   if ( $conexion->join($conexion->{channel}) )
   {
      log::eslog("irc: Entrando al canal $conexion->{channel}");
      return 1;
   }
   else
   {
      log::eslog("Error intentando entrar al canal $conexion->{channel}");
      enviar_mensaje('irc','Error intentando entrar al canal',$quien);
      if ($canal_ant ne '')
      {
         $conexion->{channel}=$canal_ant;
         irc_entrar_canal($conexion,$quien,'');
      }      
      return 0;
   }
}

sub irc_salir_canal
{
   my $conexion=$_[0];
   my $quien=$_[1];

   if ($conexion->{channel} eq '') { return 2; }
   if ( $conexion->part($conexion->{channel}) )
   {
      log::eslog("irc: Saliendo del canal $conexion->{channel}");
      $conexion->{channel}='';
      return 1;
   }
   else
   {
      log::eslog("Error intentando salir del canal $conexion->{channel}");
      enviar_mensaje('irc','Error intentando salir del canal',$quien);
      return 0;
   }
}


}
