/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.relaxng.util.ErrorHandlerImpl;
import com.thaiopensource.relaxng.util.Jaxp11XMLReaderCreator;
import com.thaiopensource.relaxng.util.ValidationEngine;
import com.thaiopensource.util.OptionParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.xml.sax.SAXException;

class TestDriver {
    private ValidationEngine engine;
    private ErrorHandlerImpl eh;
    private int nTests = 0;
    private static final String CORRECT_SCHEMA_NAME = "c.rng";
    private static final String INCORRECT_SCHEMA_NAME = "i.rng";
    private static final String VALID_INSTANCE_SUFFIX = ".v.xml";
    private static final String INVALID_INSTANCE_SUFFIX = ".i.xml";

    TestDriver() {
    }

    public static void main(String[] stringArray) throws IOException {
        System.exit(new TestDriver().doMain(stringArray));
    }

    public int doMain(String[] stringArray) throws IOException {
        long l = System.currentTimeMillis();
        this.eh = new ErrorHandlerImpl(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(stringArray[0]))));
        boolean bl = false;
        OptionParser optionParser = new OptionParser("i", stringArray);
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'i': {
                        bl = true;
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            this.eh.print(this.eh.format("invalid_option", new Object[]{optionParser.getOptionCharString()}));
            return 2;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            this.eh.print(this.eh.format("option_missing_argument", new Object[]{optionParser.getOptionCharString()}));
            return 2;
        }
        stringArray = optionParser.getRemainingArgs();
        this.engine = new ValidationEngine(new Jaxp11XMLReaderCreator(), this.eh, bl);
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            int n3 = this.runTestSuite(new File(stringArray[n2]));
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        System.err.println("Number of tests: " + this.nTests);
        System.err.println("Elapsed time: " + (System.currentTimeMillis() - l));
        this.eh.close();
        return n;
    }

    public int runTestSuite(File file) throws IOException {
        int n = 0;
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            File file2 = new File(file, stringArray[n2]);
            if (file2.isDirectory() && (n3 = this.runTestCase(file2)) > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    private int runTestCase(File file) throws IOException {
        File file2 = new File(file, INCORRECT_SCHEMA_NAME);
        if (file2.exists()) {
            if (this.loadSchema(file2)) {
                this.failed(file2);
                return 1;
            }
            return 0;
        }
        file2 = new File(file, CORRECT_SCHEMA_NAME);
        if (!file2.exists()) {
            return 0;
        }
        if (!this.loadSchema(file2)) {
            this.failed(file2);
            return 1;
        }
        String[] stringArray = file.list();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].endsWith(VALID_INSTANCE_SUFFIX)) {
                file2 = new File(file, stringArray[n2]);
                if (!this.validateInstance(file2)) {
                    this.failed(file2);
                    n = 1;
                }
            } else if (stringArray[n2].endsWith(INVALID_INSTANCE_SUFFIX) && this.validateInstance(file2 = new File(file, stringArray[n2]))) {
                this.failed(file2);
                n = 1;
            }
            ++n2;
        }
        return n;
    }

    private void failed(File file) {
        System.err.println("Failed: " + file.toString());
    }

    private boolean loadSchema(File file) throws IOException {
        ++this.nTests;
        try {
            if (this.engine.loadSchema(ValidationEngine.fileInputSource(file))) {
                return true;
            }
        }
        catch (SAXException sAXException) {
            this.eh.printException(sAXException);
        }
        return false;
    }

    private boolean validateInstance(File file) throws IOException {
        ++this.nTests;
        try {
            if (this.engine.validate(ValidationEngine.fileInputSource(file))) {
                return true;
            }
        }
        catch (SAXException sAXException) {
            this.eh.printException(sAXException);
        }
        return false;
    }
}

