/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class AttrPtg
extends Ptg
implements OperationPtg {
    public static final short sid = 25;
    private static final int SIZE = 4;
    private byte field_1_options;
    private short field_2_data;
    private BitField semiVolatile = new BitField(1);
    private BitField optiIf = new BitField(2);
    private BitField optiChoose = new BitField(4);
    private BitField optGoto = new BitField(8);
    private BitField sum = new BitField(16);
    private BitField baxcel = new BitField(32);
    private BitField space = new BitField(64);

    public AttrPtg() {
    }

    public AttrPtg(byte[] data, int offset) {
        this.field_1_options = data[++offset + 0];
        this.field_2_data = LittleEndian.getShort(data, offset + 1);
        System.out.println("OPTIONS = " + Integer.toHexString(this.getOptions()));
        System.out.println("OPTIONS & 0x10 = " + (this.getOptions() & 0x10));
        System.out.println(this.toString());
    }

    public void setOptions(byte options) {
        this.field_1_options = options;
    }

    public byte getOptions() {
        return this.field_1_options;
    }

    public boolean isSemiVolatile() {
        return this.semiVolatile.isSet(this.getOptions());
    }

    public boolean isOptimizedIf() {
        return this.optiIf.isSet(this.getOptions());
    }

    public boolean isOptimizedChoose() {
        return this.optiChoose.isSet(this.getOptions());
    }

    public boolean isGoto() {
        return this.optGoto.isSet(this.getOptions());
    }

    public boolean isSum() {
        return this.sum.isSet(this.getOptions());
    }

    public boolean isBaxcel() {
        return this.baxcel.isSet(this.getOptions());
    }

    public boolean isSpace() {
        return this.space.isSet(this.getOptions());
    }

    public void setData(short data) {
        this.field_2_data = data;
    }

    public short getData() {
        return this.field_2_data;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AttrPtg\n");
        buffer.append("options=").append(this.field_1_options).append("\n");
        buffer.append("data   =").append(this.field_2_data).append("\n");
        buffer.append("semi   =").append(this.isSemiVolatile()).append("\n");
        buffer.append("optimif=").append(this.isOptimizedIf()).append("\n");
        buffer.append("optchos=").append(this.isOptimizedChoose()).append("\n");
        buffer.append("isGoto =").append(this.isGoto()).append("\n");
        buffer.append("isSum  =").append(this.isSum()).append("\n");
        buffer.append("isBaxce=").append(this.isBaxcel()).append("\n");
        buffer.append("isSpace=").append(this.isSpace()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
    }

    public int getSize() {
        return 4;
    }

    public String toFormulaString() {
        return "SUM()";
    }

    public String toFormulaString(Ptg[] operands) {
        return "SUM(" + operands[0].toFormulaString() + ")";
    }

    public int getNumberOfOperands() {
        return 1;
    }

    public int getType() {
        return -1;
    }

    static {
        sid = (short)25;
        SIZE = 4;
    }
}

