/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Global;

public class Main {
    protected static ToolErrorReporter errorReporter;
    protected static Global global;
    protected static int exitCode;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    static boolean processStdin;
    static Vector fileList;

    public static void main(String[] stringArray) {
        int n = Main.exec(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int exec(String[] stringArray) {
        Context context = Context.enter();
        global = Main.getGlobal();
        errorReporter = new ToolErrorReporter(false, global.getErr());
        context.setErrorReporter(errorReporter);
        stringArray = Main.processOptions(context, stringArray);
        if (processStdin) {
            fileList.addElement(null);
        }
        String[] stringArray2 = stringArray;
        Scriptable scriptable = context.newArray((Scriptable)global, stringArray);
        global.defineProperty("arguments", scriptable, 2);
        int n = 0;
        while (n < fileList.size()) {
            Main.processSource(context, (String)fileList.elementAt(n));
            ++n;
        }
        Context.exit();
        return exitCode;
    }

    public static Global getGlobal() {
        if (global == null) {
            try {
                global = new Global(Context.enter());
                Object var1 = null;
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            {
            }
        }
        return global;
    }

    public static String[] processOptions(Context context, String[] stringArray) {
        context.setTargetPackage("");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!string.startsWith("-")) {
                processStdin = false;
                fileList.addElement(string);
                String[] stringArray2 = new String[stringArray.length - n - 1];
                System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray.length - n - 1);
                return stringArray2;
            }
            if (string.equals("-version")) {
                double d;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                if ((d = Context.toNumber(stringArray[n])) != d) {
                    Main.usage(string);
                }
                context.setLanguageVersion((int)d);
            } else if (string.equals("-opt") || string.equals("-O")) {
                double d;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                if ((d = Context.toNumber(stringArray[n])) != d) {
                    Main.usage(string);
                }
                context.setOptimizationLevel((int)d);
            } else if (string.equals("-e")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                StringReader stringReader = new StringReader(stringArray[n]);
                Main.evaluateReader(context, global, stringReader, "<command>", 1);
            } else if (string.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (string.equals("-f")) {
                processStdin = false;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                fileList.addElement(stringArray[n].equals("-") ? null : stringArray[n]);
            } else {
                Main.usage(string);
            }
            ++n;
        }
        return new String[0];
    }

    public static void usage(String string) {
        Main.p(ToolErrorReporter.getMessage("msg.shell.usage", string));
        System.exit(1);
    }

    public static void processSource(Context context, String string) {
        if (string == null || string.equals("-")) {
            if (string == null) {
                Main.getOut().println(context.getImplementationVersion());
            }
            context.setOptimizationLevel(-1);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(global.getIn()));
            int n = 1;
            boolean bl = false;
            while (!bl) {
                Object object;
                int n2 = n;
                if (string == null) {
                    global.getErr().print("js> ");
                }
                global.getErr().flush();
                String string2 = "";
                do {
                    try {
                        object = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                        break;
                    }
                    if (object == null) {
                        bl = true;
                        break;
                    }
                    string2 = string2 + (String)object + "\n";
                    ++n;
                } while (!context.stringIsCompilableUnit(string2));
                object = new StringReader(string2);
                Object object2 = Main.evaluateReader(context, global, (Reader)object, "<stdin>", n2);
                if (object2 != Context.getUndefinedValue()) {
                    try {
                        global.getErr().println(Context.toString(object2));
                    }
                    catch (EcmaError ecmaError) {
                        String string3 = ToolErrorReporter.getMessage("msg.uncaughtJSException", ecmaError.toString());
                        exitCode = 3;
                        if (ecmaError.getSourceName() != null) {
                            Context.reportError(string3, ecmaError.getSourceName(), ecmaError.getLineNumber(), ecmaError.getLineSource(), ecmaError.getColumnNumber());
                        }
                        Context.reportError(string3);
                    }
                }
                NativeArray nativeArray = Main.global.history;
                nativeArray.put((int)nativeArray.jsGet_length(), (Scriptable)nativeArray, (Object)string2);
            }
            global.getErr().println();
        } else {
            Main.processFile(context, global, string);
        }
        System.gc();
    }

    public static void processFile(Context context, Scriptable scriptable, String string) {
        Reader reader = null;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            reader = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (MalformedURLException malformedURLException) {
            reader = null;
        }
        catch (IOException iOException) {
            Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open.url", string, iOException.toString()));
            exitCode = 4;
            return;
        }
        if (reader == null) {
            try {
                reader = new PushbackReader(new FileReader(string));
                int n = reader.read();
                if (n == 35) {
                    while ((n = reader.read()) != -1) {
                        if (n == 10 || n == 13) break;
                    }
                    ((PushbackReader)reader).unread(n);
                } else {
                    reader.close();
                    reader = new FileReader(string);
                }
                string = new File(string).getCanonicalPath();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", string));
                exitCode = 4;
                return;
            }
            catch (IOException iOException) {
                global.getErr().println(iOException.toString());
            }
        }
        Main.evaluateReader(context, scriptable, reader, string, 1);
    }

    /*
     * Loose catch block
     */
    public static Object evaluateReader(Context context, Scriptable scriptable, Reader reader, String string, int n) {
        Object object;
        block19: {
            object = Context.getUndefinedValue();
            object = context.evaluateReader(scriptable, reader, string, n, null);
            Object var12_6 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                global.getErr().println(iOException.toString());
            }
            break block19;
            {
                catch (WrappedException wrappedException) {
                    global.getErr().println(wrappedException.getWrappedException().toString());
                    wrappedException.printStackTrace();
                    Object var12_7 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                    }
                    break block19;
                }
                catch (EcmaError ecmaError) {
                    String string2 = ToolErrorReporter.getMessage("msg.uncaughtJSException", ecmaError.toString());
                    exitCode = 3;
                    if (ecmaError.getSourceName() != null) {
                        Context.reportError(string2, ecmaError.getSourceName(), ecmaError.getLineNumber(), ecmaError.getLineSource(), ecmaError.getColumnNumber());
                    } else {
                        Context.reportError(string2);
                    }
                    Object var12_8 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                    }
                    break block19;
                }
                catch (EvaluatorException evaluatorException) {
                    exitCode = 3;
                    Object var12_9 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                    }
                    break block19;
                }
                catch (JavaScriptException javaScriptException) {
                    Object object2 = javaScriptException.getValue();
                    if (object2 instanceof ThreadDeath) {
                        throw (ThreadDeath)object2;
                    }
                    exitCode = 3;
                    Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", javaScriptException.getMessage()));
                    Object var12_10 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        global.getErr().println(iOException.toString());
                    }
                    break block19;
                }
                catch (IOException iOException) {
                    global.getErr().println(iOException.toString());
                    Object var12_11 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException2) {
                        global.getErr().println(iOException2.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    global.getErr().println(iOException.toString());
                }
                throw throwable;
            }
        }
        return object;
    }

    private static void p(String string) {
        global.getOut().println(string);
    }

    public static ScriptableObject getScope() {
        return global;
    }

    public static InputStream getIn() {
        return Global.getInstance(Main.getGlobal()).getIn();
    }

    public static void setIn(InputStream inputStream) {
        Global.getInstance(Main.getGlobal()).setIn(inputStream);
    }

    public static PrintStream getOut() {
        return Global.getInstance(Main.getGlobal()).getOut();
    }

    public static void setOut(PrintStream printStream) {
        Global.getInstance(Main.getGlobal()).setOut(printStream);
    }

    public static PrintStream getErr() {
        return Global.getInstance(Main.getGlobal()).getErr();
    }

    public static void setErr(PrintStream printStream) {
        Global.getInstance(Main.getGlobal()).setErr(printStream);
    }

    static {
        exitCode = 0;
        processStdin = true;
        fileList = new Vector(5);
    }
}

