/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.components.parser.Parser;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.util.Tokenizer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSPUtil {
    private static volatile int count = 0;

    public static String pathComponent(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : filename;
    }

    public static String fileComponent(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(i + 1) : filename;
    }

    public static String baseName(String filename) {
        return XSPUtil.baseName(filename, ".");
    }

    public static String baseName(String filename, String suffix) {
        int lastDot = filename.lastIndexOf(suffix);
        if (lastDot >= 0) {
            filename = filename.substring(0, lastDot);
        }
        return filename;
    }

    public static String normalizedBaseName(String filename) {
        filename = XSPUtil.baseName(filename);
        return XSPUtil.normalizedName(filename);
    }

    public static String normalizedName(String filename) {
        String[] path = XSPUtil.split(filename, File.separator);
        int start = path[0].length() == 0 ? 1 : 0;
        StringBuffer buffer = new StringBuffer();
        int i = start;
        while (i < path.length) {
            if (i > start) {
                buffer.append(File.separator);
            }
            buffer.append('_');
            char[] chars = path[i].toCharArray();
            int j = 0;
            while (j < chars.length) {
                if (XSPUtil.isAlphaNumeric(chars[j])) {
                    buffer.append(chars[j]);
                } else {
                    buffer.append('_');
                }
                ++j;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String relativeFilename(String filename, Map objectModel) throws IOException {
        File file = new File(filename);
        if (file.isAbsolute() && file.exists()) {
            return filename;
        }
        Context context = ObjectModelHelper.getContext(objectModel);
        return NetUtils.getPath(context.getResource(filename).toExternalForm());
    }

    public static boolean isAlphaNumeric(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static String[] split(String line) {
        return XSPUtil.split(line, " \t\r\f\n");
    }

    public static String[] split(String line, String delimiter) {
        Tokenizer tokenizer = new Tokenizer(line, delimiter);
        int tokenCount = tokenizer.countTokens();
        String[] result = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    public static void include(InputSource is, ContentHandler parentContentHandler, Parser parser) throws SAXException, IOException {
        parser.setConsumer(new IncludeXMLConsumer(parentContentHandler));
        parser.parse(is);
    }

    public static String encodeMarkup(String string) {
        char[] array = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            switch (array[i]) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                default: {
                    buffer.append(array[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String formEncode(String text) throws Exception {
        return URLEncoder.encode(text);
    }

    public static String formDecode(String s) throws Exception {
        return URLDecoder.decode(s);
    }

    public static String getURLContents(String url, URLFactory urlFactory) throws IOException {
        return XSPUtil.getContents(urlFactory.getURL(url).openStream());
    }

    public static String getURLContents(String url, String encoding, URLFactory urlFactory) throws IOException {
        return XSPUtil.getContents(urlFactory.getURL(url).openStream(), encoding);
    }

    public static String getFileContents(String filename) throws IOException {
        return XSPUtil.getContents(new BufferedReader(new FileReader(filename)));
    }

    public static String getFileContents(String filename, String encoding) throws IOException {
        return XSPUtil.getContents(new BufferedInputStream(new FileInputStream(filename)), encoding);
    }

    public static String getContents(InputStream in, String encoding) throws IOException {
        return XSPUtil.getContents(new BufferedReader(new InputStreamReader(in, encoding)));
    }

    public static String getContents(InputStream in) throws IOException {
        return XSPUtil.getContents(new BufferedReader(new InputStreamReader(in)));
    }

    /*
     * WARNING - void declaration
     */
    public static String getContents(Reader reader) throws IOException {
        int len;
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        while ((len = reader.read(chr)) > 0) {
            void var1_3;
            buffer.append(chr, 0, (int)var1_3);
        }
        return buffer.toString();
    }

    public static String formatDate(Date date, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy/MM/dd hh:mm:ss aa";
        }
        try {
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            return date.toString();
        }
    }

    public static int getCount() {
        return ++count;
    }

    public static int getSessionCount(Session session) {
        Session session2 = session;
        synchronized (session2) {
            Integer integer = (Integer)session.getAttribute("util.counter");
            if (integer == null) {
                integer = new Integer(0);
            }
            int cnt = integer + 1;
            session.setAttribute("util.counter", new Integer(cnt));
            int n = cnt;
            return n;
        }
    }

    public static Object getContextAttribute(Map objectModel, String name) {
        Context context = ObjectModelHelper.getContext(objectModel);
        return context.getAttribute(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSourceAsString(String uri, SourceResolver resolver) throws RuntimeException {
        Source resource;
        StringBuffer result;
        block14: {
            result = new StringBuffer();
            InputStream stream = null;
            resource = null;
            try {
                block13: {
                    try {
                        resource = resolver.resolve(uri);
                        long length = resource.getContentLength();
                        stream = new BufferedInputStream(resource.getInputStream());
                        if (length != -1L) {
                            byte[] buffer2 = new byte[new Long(length).intValue()];
                            stream.read(buffer2);
                            stream.close();
                            if (buffer2 != null) {
                                result.append(new String(buffer2));
                            }
                            break block13;
                        }
                        int readBytes = 0;
                        while (true) {
                            byte[] buffer;
                            if ((readBytes = stream.read(buffer = new byte[4096])) == -1) {
                                stream.close();
                                break;
                            }
                            if (readBytes <= 0) continue;
                            result.append(new String(buffer, 0, readBytes));
                        }
                    }
                    catch (Exception e) {
                        throw new CascadingRuntimeException("Failed to get " + uri + " as string", (Throwable)e);
                    }
                }
                Object var10_10 = null;
                if (stream == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception ase) {
                        throw new CascadingRuntimeException("Failed to close stream", (Throwable)ase);
                    }
                }
                if (resource == null) throw throwable;
                resource.recycle();
                throw throwable;
            }
            try {}
            catch (Exception ase) {
                throw new CascadingRuntimeException("Failed to close stream", (Throwable)ase);
            }
            stream.close();
        }
        if (resource == null) return result.toString();
        resource.recycle();
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void includeSource(String uri, String base, SourceResolver resolver, ContentHandler contentHandler) throws RuntimeException {
        base = base == null ? "" : base;
        Source source = null;
        try {
            try {
                source = resolver.resolve(base + uri);
                source.toSAX(new IncludeXMLConsumer(contentHandler));
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Error including source " + base + " " + uri, (Throwable)e);
            }
            Object var7_5 = null;
            if (source == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (source == null) throw throwable;
            source.recycle();
            throw throwable;
        }
        source.recycle();
    }

    public static void includeString(String string, ComponentManager manager, ContentHandler contentHandler) throws RuntimeException {
        XSPUtil.includeInputSource(new InputSource(new StringReader(String.valueOf(string))), manager, contentHandler);
    }

    public static void includeFile(String name, ComponentManager manager, ContentHandler contentHandler, Map objectModel) throws RuntimeException {
        try {
            XSPUtil.includeInputSource(new InputSource(new FileReader(XSPUtil.relativeFilename(name, objectModel))), manager, contentHandler);
        }
        catch (IOException e) {
            throw new CascadingRuntimeException("Could not include file " + name, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void includeInputSource(InputSource source, ComponentManager manager, ContentHandler contentHandler) throws RuntimeException {
        Parser newParser = null;
        try {
            try {
                newParser = (Parser)manager.lookup("org.apache.cocoon.components.parser.Parser");
                XSPUtil.include(source, contentHandler, newParser);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Could not include page", (Throwable)e);
            }
            Object var6_4 = null;
            if (newParser == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (newParser == null) throw throwable;
            manager.release((Component)newParser);
            throw throwable;
        }
        manager.release((Component)newParser);
    }
}

