/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ZipArchiveSerializer
extends AbstractSerializer {
    public static final String ZIP_NAMESPACE = "http://apache.org/cocoon/zip-archive/1.0";
    protected ZipOutputStream zipOutput;
    protected boolean inZip = false;
    protected SourceResolver resolver;
    protected byte[] buffer = new byte[1024];

    public String getMimeType() {
        return "application/x-zip";
    }

    public void startDocument() throws SAXException {
        this.zipOutput = new ZipOutputStream(this.output);
        this.inZip = false;
        this.resolver = CocoonComponentManager.getCurrentEnvironment();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.inZip) {
            if (!namespaceURI.equals(ZIP_NAMESPACE) || !localName.equals("archive")) throw new SAXException("Expecting 'archive' root element (got '" + localName + "')");
            this.inZip = true;
            return;
        } else {
            if (!namespaceURI.equals(ZIP_NAMESPACE) || !localName.equals("entry")) throw new SAXException("Expecting 'entry' element (got '" + localName + "')");
            this.addEntry(atts);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addEntry(Attributes atts) throws SAXException {
        String name = atts.getValue("name");
        if (name == null) {
            throw new SAXException("No name given to the Zip entry");
        }
        String src = atts.getValue("src");
        if (src == null) {
            throw new SAXException("No source given for the Zip entry");
        }
        try {
            int len;
            ZipEntry entry = new ZipEntry(name);
            this.zipOutput.putNextEntry(entry);
            Source source = this.resolver.resolve(src);
            InputStream sourceInput = source.getInputStream();
            while ((len = sourceInput.read(this.buffer)) > 0) {
                void var7_10;
                this.zipOutput.write(this.buffer, 0, (int)var7_10);
            }
            this.zipOutput.closeEntry();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.zipOutput.finish();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }
}

