/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.PackageFunctions;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.JXPathCompiledExpression;
import org.apache.commons.jxpath.ri.Parser;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.axes.RootContext;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.TreeCompiler;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.VariablePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPointerFactory;
import org.apache.commons.jxpath.ri.model.beans.CollectionPointerFactory;
import org.apache.commons.jxpath.ri.model.beans.DynamicPointerFactory;
import org.apache.commons.jxpath.ri.model.container.ContainerPointerFactory;
import org.apache.commons.jxpath.util.TypeUtils;

public class JXPathContextReferenceImpl
extends JXPathContext {
    private static final Compiler compiler = new TreeCompiler();
    private static final Map compiled = new HashMap();
    private static final PackageFunctions genericFunctions = new PackageFunctions("", null);
    private static boolean useSoftCache = true;
    private static int cleanupCount = 0;
    private static Vector nodeFactories = new Vector();
    private static NodePointerFactory[] nodeFactoryArray = null;
    private NodePointer rootPointer;
    private static final int CLEANUP_THRESHOLD = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JXPathContextReferenceImpl(JXPathContext parentContext, Object contextBean) {
        super(parentContext, contextBean);
        Vector vector = nodeFactories;
        synchronized (vector) {
            JXPathContextReferenceImpl.createNodeFactoryArray();
        }
    }

    private static void createNodeFactoryArray() {
        if (nodeFactoryArray == null) {
            nodeFactoryArray = nodeFactories.toArray(new NodePointerFactory[0]);
            Arrays.sort(nodeFactoryArray, new Comparator(){

                public int compare(Object a, Object b) {
                    int orderA = ((NodePointerFactory)a).getOrder();
                    int orderB = ((NodePointerFactory)b).getOrder();
                    return orderA - orderB;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNodePointerFactory(NodePointerFactory factory) {
        Vector vector = nodeFactories;
        synchronized (vector) {
            nodeFactories.add(factory);
            nodeFactoryArray = null;
        }
    }

    public static NodePointerFactory[] getNodePointerFactories() {
        return nodeFactoryArray;
    }

    protected CompiledExpression compilePath(String xpath) {
        return new JXPathCompiledExpression(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    private static Expression compileExpression(String xpath) {
        Expression expr;
        if (useSoftCache) {
            expr = null;
            SoftReference ref = (SoftReference)compiled.get(xpath);
            if (ref != null) {
                expr = (Expression)ref.get();
            }
            if (expr == null) {
                expr = (Expression)Parser.parseExpression(xpath, compiler);
                compiled.put(xpath, new SoftReference<Expression>(expr));
                if (cleanupCount++ >= 500) {
                    JXPathContextReferenceImpl.cleanupCache();
                }
            }
        } else {
            expr = (Expression)compiled.get(xpath);
            if (expr == null) {
                expr = (Expression)Parser.parseExpression(xpath, compiler);
                compiled.put(xpath, expr);
            }
        }
        return expr;
    }

    private static void cleanupCache() {
        Iterator it = compiled.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            if (((SoftReference)me.getValue()).get() != null) continue;
            it.remove();
        }
        cleanupCount = 0;
    }

    public Object getValue(String xpath) {
        return this.getValue(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    public Object getValue(String xpath, Expression expr) {
        Object result = expr.computeValue(this.getRootContext());
        if (result == null && !this.lenient) {
            throw new JXPathException("No value for xpath: " + xpath);
        }
        if (result instanceof EvalContext) {
            EvalContext ctx = (EvalContext)result;
            result = ctx.getSingleNodePointer();
        }
        if (result instanceof NodePointer) {
            result = ((NodePointer)result).getValue();
        }
        return result;
    }

    public Object getValue(String xpath, Class requiredType) {
        Expression expr = JXPathContextReferenceImpl.compileExpression(xpath);
        return this.getValue(xpath, expr, requiredType);
    }

    public Object getValue(String xpath, Expression expr, Class requiredType) {
        Object value = this.getValue(xpath, expr);
        if (value != null && requiredType != null) {
            if (!TypeUtils.canConvert(value, requiredType)) {
                throw new JXPathException("Invalid expression type. '" + xpath + "' returns " + value.getClass().getName() + ". It cannot be converted to " + requiredType.getName());
            }
            value = TypeUtils.convert(value, requiredType);
        }
        return value;
    }

    public Iterator iterate(String xpath) {
        return this.iterate(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    public Iterator iterate(String xpath, Expression expr) {
        return expr.iterate(this.getRootContext());
    }

    public Pointer getPointer(String xpath) {
        return this.getPointer(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    public Pointer getPointer(String xpath, Expression expr) {
        Object result = expr.computeValue(this.getRootContext());
        if (result instanceof EvalContext) {
            result = ((EvalContext)result).getSingleNodePointer();
        }
        if (result instanceof Pointer) {
            return (Pointer)result;
        }
        return NodePointer.newNodePointer(null, result, this.getLocale());
    }

    public void setValue(String xpath, Object value) {
        this.setValue(xpath, JXPathContextReferenceImpl.compileExpression(xpath), value);
    }

    public void setValue(String xpath, Expression expr, Object value) {
        try {
            this.setValue(xpath, expr, value, false);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to set value with xpath " + xpath, ex);
        }
    }

    public Pointer createPath(String xpath) {
        return this.createPath(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    public Pointer createPath(String xpath, Expression expr) {
        try {
            Object result = expr.computeValue(this.getRootContext());
            Pointer pointer = null;
            if (result instanceof Pointer) {
                pointer = (Pointer)result;
            } else if (result instanceof EvalContext) {
                EvalContext ctx = (EvalContext)result;
                pointer = ctx.getSingleNodePointer();
            } else {
                throw new JXPathException("Expression is not a path:" + xpath);
            }
            return ((NodePointer)pointer).createPath(this);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to create xpath " + xpath, ex);
        }
    }

    public Pointer createPathAndSetValue(String xpath, Object value) {
        return this.createPathAndSetValue(xpath, JXPathContextReferenceImpl.compileExpression(xpath), value);
    }

    public Pointer createPathAndSetValue(String xpath, Expression expr, Object value) {
        try {
            return this.setValue(xpath, expr, value, true);
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to create xpath " + xpath, ex);
        }
    }

    private Pointer setValue(String xpath, Expression expr, Object value, boolean create) {
        Object result = expr.computeValue(this.getRootContext());
        Pointer pointer = null;
        if (result instanceof Pointer) {
            pointer = (Pointer)result;
        } else if (result instanceof EvalContext) {
            EvalContext ctx = (EvalContext)result;
            pointer = ctx.getSingleNodePointer();
        } else {
            throw new JXPathException("Cannot set value for xpath: " + xpath);
        }
        if (create) {
            pointer = ((NodePointer)pointer).createPath(this, value);
        } else {
            pointer.setValue(value);
        }
        return pointer;
    }

    public Iterator iteratePointers(String xpath) {
        return this.iteratePointers(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    public Iterator iteratePointers(String xpath, Expression expr) {
        return expr.iteratePointers(this.getRootContext());
    }

    public void removePath(String xpath) {
        this.removePath(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    public void removePath(String xpath, Expression expr) {
        try {
            NodePointer pointer = (NodePointer)this.getPointer(xpath, expr);
            if (pointer != null) {
                pointer.remove();
            }
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to remove xpath " + xpath, ex);
        }
    }

    public void removeAll(String xpath) {
        this.removeAll(xpath, JXPathContextReferenceImpl.compileExpression(xpath));
    }

    public void removeAll(String xpath, Expression expr) {
        try {
            ArrayList list = new ArrayList();
            Iterator it = expr.iterate(this.getRootContext());
            while (it.hasNext()) {
                list.add(it.next());
            }
            Collections.sort(list);
            int i = list.size() - 1;
            while (i >= 0) {
                NodePointer pointer = (NodePointer)list.get(i);
                pointer.remove();
                --i;
            }
        }
        catch (Throwable ex) {
            throw new JXPathException("Exception trying to remove all for xpath " + xpath, ex);
        }
    }

    public synchronized Pointer getContextPointer() {
        if (this.rootPointer == null) {
            this.rootPointer = NodePointer.newNodePointer(new QName(null, "root"), this.getContextBean(), this.getLocale());
        }
        return this.rootPointer;
    }

    private EvalContext getRootContext() {
        return new RootContext(this, (NodePointer)this.getContextPointer());
    }

    public NodePointer getVariablePointer(QName name) {
        String varName = name.toString();
        JXPathContext varCtx = this;
        Variables vars = null;
        while (varCtx != null) {
            vars = varCtx.getVariables();
            if (vars.isDeclaredVariable(varName)) break;
            varCtx = varCtx.getParentContext();
            vars = null;
        }
        if (vars != null) {
            return new VariablePointer(vars, name);
        }
        return new VariablePointer(name);
    }

    public Function getFunction(QName functionName, Object[] parameters) {
        String namespace = functionName.getPrefix();
        String name = functionName.getName();
        JXPathContext funcCtx = this;
        Function func = null;
        while (funcCtx != null) {
            Functions funcs = funcCtx.getFunctions();
            if (funcs == null) break;
            func = funcs.getFunction(namespace, name, parameters);
            if (func != null) {
                return func;
            }
            funcCtx = funcCtx.getParentContext();
        }
        if ((func = genericFunctions.getFunction(namespace, name, parameters)) != null) {
            return func;
        }
        throw new JXPathException("Undefined function: " + functionName.toString());
    }

    public static Object allocateConditionally(String className, String existenceCheckClassName) {
        try {
            try {
                Class.forName(existenceCheckClassName);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
            Class<?> cls = Class.forName(className);
            return cls.newInstance();
        }
        catch (Exception ex) {
            throw new JXPathException("Cannot allocate " + className, ex);
        }
    }

    static {
        nodeFactories.add(new CollectionPointerFactory());
        nodeFactories.add(new BeanPointerFactory());
        nodeFactories.add(new DynamicPointerFactory());
        Object domFactory = JXPathContextReferenceImpl.allocateConditionally("org.apache.commons.jxpath.ri.model.dom.DOMPointerFactory", "org.w3c.dom.Node");
        if (domFactory != null) {
            nodeFactories.add(domFactory);
        }
        nodeFactories.add(new ContainerPointerFactory());
        JXPathContextReferenceImpl.createNodeFactoryArray();
        CLEANUP_THRESHOLD = 500;
    }
}

