/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class PropertyPointer
extends NodePointer {
    public static int UNSPECIFIED_PROPERTY = Integer.MIN_VALUE;
    protected int propertyIndex = UNSPECIFIED_PROPERTY;
    protected Object bean;
    private static final Object UNINITIALIZED = new Object();
    private Object value = UNINITIALIZED;

    public PropertyPointer(NodePointer parent) {
        super(parent);
    }

    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public void setPropertyIndex(int index) {
        this.propertyIndex = index;
        index = NodePointer.WHOLE_COLLECTION;
    }

    public Object getBean() {
        if (this.bean == null) {
            this.bean = this.getParent().getNodeValue();
        }
        return this.bean;
    }

    public QName getName() {
        return new QName(null, this.getPropertyName());
    }

    public abstract String getPropertyName();

    public abstract void setPropertyName(String var1);

    public abstract int getPropertyCount();

    public abstract String[] getPropertyNames();

    protected abstract boolean isActualProperty();

    public boolean isActual() {
        if (!this.isActualProperty()) {
            return false;
        }
        return super.isActual();
    }

    public Object getNodeValue() {
        if (this.value == UNINITIALIZED) {
            this.value = this.index == NodePointer.WHOLE_COLLECTION ? this.getBaseValue() : ValueUtils.getValue(this.getBaseValue(), this.index);
        }
        return this.value;
    }

    public NodePointer getValuePointer() {
        return NodePointer.newChildNodePointer(this, this.getName(), this.getNodeValue());
    }

    public int hashCode() {
        return this.getParent().hashCode() + this.propertyIndex + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertyPointer)) {
            return false;
        }
        PropertyPointer other = (PropertyPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.getPropertyIndex() != other.getPropertyIndex() || !this.getPropertyName().equals(other.getPropertyName())) {
            return false;
        }
        int i_this = this.index == NodePointer.WHOLE_COLLECTION ? 0 : this.index;
        int i_other = other.index == NodePointer.WHOLE_COLLECTION ? 0 : other.index;
        return i_this == i_other;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return this.getValuePointer().compareChildNodePointers(pointer1, pointer2);
    }
}

