/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPFilter;
import com.hp.hpl.jena.rdf.arp.ARPString;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.AboutEachAction;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.URIReference;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

class ARPResource
implements AResource {
    private static final String RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final int RDFNS_LENGTH = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".length();
    private static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static AResource RDF_STATEMENT;
    static URIReference RDF_BAG;
    static URIReference RDF_SEQ;
    static URIReference RDF_ALT;
    private static String RDF_LI;
    private static AResource RDF_TYPE;
    private static AResource RDF_SUBJECT;
    private static AResource RDF_PREDICATE;
    private static AResource RDF_OBJECT;
    private ARPFilter arp;
    private boolean disabled = false;
    private String uri;
    private ARPResource bag = null;
    private static int genIdCounter;
    private final int genId = genIdCounter++;
    private Vector aboutEachTriples;
    private int liCounter = 1;
    static String dummy;
    private static URIReference[] _rdf_n;
    private Object userData;

    ARPResource(ARPFilter aRPFilter) {
        this.arp = aRPFilter;
    }

    void setBagId(String string) {
        this.bag = new ARPResource(this.arp);
        this.bag.setAbout(string);
        this.bag.setType(RDF_BAG);
    }

    void setAbout(URIReference uRIReference) {
        this.setAbout(uRIReference.toString());
    }

    void setAbout(String string) {
        this.uri = string.startsWith(dummy) ? string.substring(dummy.length()) : string;
    }

    private void disable() {
        this.disabled = true;
        this.aboutEachTriples = new Vector();
    }

    void setAboutEach(URIReference uRIReference) {
        this.disable();
        this.setAbout(uRIReference);
        this.arp.addAboutEach(this);
    }

    void setLiObject(Object object, String string) {
        this.setPredObject(ARPResource.rdf_n(this.liCounter++), object, this.reify(string));
        this.isMember(object);
    }

    void setMemberObject(AResource aResource, ARPString aRPString) {
        this.setPredObject(aResource, aRPString, null);
        this.isMember(aRPString);
    }

    private void isMember(Object object) {
        if (object instanceof AResource && this.uri != null) {
            this.arp.addMember(this.uri, (AResource)object);
        }
    }

    void setMemberObject(AResource aResource, Object object, String string) {
        this.setPredObject(aResource, object, this.reify(string));
        this.isMember(object);
    }

    void setPredicateObject(AResource aResource, ARPString aRPString) {
        this.setPredObject(aResource, aRPString, null);
    }

    void setPredicateObject(AResource aResource, Object object, String string) {
        this.setPredObject(aResource, object, this.reify(string));
    }

    AResource reify(String string) {
        ARPResource aRPResource = null;
        if (string != null) {
            aRPResource = new ARPResource(this.arp);
            aRPResource.setAbout(string);
        }
        return aRPResource;
    }

    void setType(URIReference uRIReference) {
        this.setPredObject(RDF_TYPE, uRIReference, null);
    }

    private void setPredObject(AResource aResource, Object object, AResource aResource2) {
        this.triple(this, aResource, object);
        if (this.bag != null) {
            if (aResource2 == null) {
                aResource2 = new ARPResource(this.arp);
            }
            this.bag.setLiObject(aResource2, null);
        }
        if (aResource2 != null) {
            this.tripleRes(aResource2, RDF_TYPE, RDF_STATEMENT);
            this.tripleRes(aResource2, RDF_SUBJECT, this);
            this.tripleRes(aResource2, RDF_PREDICATE, aResource);
            this.triple(aResource2, RDF_OBJECT, object);
        }
    }

    private void triple(AResource aResource, AResource aResource2, Object object) {
        int n = 0;
        if (object instanceof AResource) {
            ++n;
        }
        if (object instanceof ALiteral) {
            n += 2;
        }
        switch (n) {
            case 1: {
                this.tripleRes(aResource, aResource2, (AResource)object);
                break;
            }
            case 2: {
                this.tripleLit(aResource, aResource2, (ALiteral)object);
                break;
            }
            default: {
                throw new RuntimeException("Assertion failure: sw = " + n);
            }
        }
    }

    private void tripleRes(final AResource aResource, final AResource aResource2, final AResource aResource3) {
        if (this.disabled) {
            if (aResource == this) {
                this.aboutEachTriples.add(new AboutEachAction(){

                    public void apply(AResource aResource, StatementHandler statementHandler) {
                        statementHandler.statement(aResource, aResource2, aResource3);
                    }
                });
                return;
            }
            if (aResource3 == this) {
                this.aboutEachTriples.add(new AboutEachAction(){

                    public void apply(AResource aResource3, StatementHandler statementHandler) {
                        statementHandler.statement(aResource, aResource2, aResource3);
                    }
                });
                return;
            }
        }
        this.arp.statementHandler.statement(aResource, aResource2, aResource3);
    }

    private void tripleLit(AResource aResource, final AResource aResource2, final ALiteral aLiteral) {
        if (this.disabled && aResource == this) {
            this.aboutEachTriples.add(new AboutEachAction(){

                public void apply(AResource aResource, StatementHandler statementHandler) {
                    statementHandler.statement(aResource, aResource2, aLiteral);
                }
            });
        } else {
            this.arp.statementHandler.statement(aResource, aResource2, aLiteral);
        }
    }

    void applyAboutEach(AResource aResource) {
        Iterator iterator = ((AbstractList)this.aboutEachTriples).iterator();
        while (iterator.hasNext()) {
            ((AboutEachAction)iterator.next()).apply(aResource, this.arp.statementHandler);
        }
    }

    private static URIReference rdf_n(int n) {
        if (n >= _rdf_n.length) {
            int n2 = (n + 10) * 3 / 2;
            URIReference[] uRIReferenceArray = new URIReference[n2];
            System.arraycopy(_rdf_n, 0, uRIReferenceArray, 0, _rdf_n.length);
            int n3 = _rdf_n.length;
            while (n3 < n2) {
                try {
                    uRIReferenceArray[n3] = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + n3);
                }
                catch (MalformedURIException malformedURIException) {
                    throw new RuntimeException("Impossible: RDF_nnn handling logic error.");
                }
                ++n3;
            }
            _rdf_n = uRIReferenceArray;
        }
        return _rdf_n[n];
    }

    static int isRDF_N(AResource aResource) {
        String string;
        if (!aResource.isAnonymous() && (string = aResource.getURI()).length() > RDFNS_LENGTH && string.charAt(RDFNS_LENGTH) == '_') {
            try {
                String string2 = string.substring(RDFNS_LENGTH + 1);
                int n = Integer.parseInt(string2);
                if (n > 0 && string.startsWith(RDFNS)) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean isAnonymous() {
        return this.uri == null;
    }

    public String getAnonymousID() {
        return Integer.toString(this.genId);
    }

    public String getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri == null ? "_" + this.genId : this.uri;
    }

    public int hashCode() {
        if (this.uri == null) {
            return this.genId;
        }
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AResource)) {
            return false;
        }
        AResource aResource = (AResource)object;
        if (this.uri == null) {
            return aResource.isAnonymous() && aResource.getAnonymousID().equals(this.getAnonymousID());
        }
        return !aResource.isAnonymous() && this.uri.equals(aResource.getURI());
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    static {
        try {
            RDF_STATEMENT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement".intern());
            RDF_BAG = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag".intern());
            RDF_SEQ = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq".intern());
            RDF_ALT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt".intern());
            RDF_LI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#li".intern();
            RDF_TYPE = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".intern());
            RDF_SUBJECT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject".intern());
            RDF_PREDICATE = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate".intern());
            RDF_OBJECT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#object".intern());
        }
        catch (MalformedURIException malformedURIException) {
            System.err.println("Internal error: " + malformedURIException.toString());
            malformedURIException.printStackTrace();
        }
        genIdCounter = 0;
        dummy = "http://jena.hpl.hp.com/arp/not/a/real/uri/";
        _rdf_n = new URIReference[0];
    }
}

