/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.bdb;

import com.hp.hpl.mesa.rdf.jena.model.RDFException;

public class BDBException
extends RDFException {
    protected static final int MINERRORCODE = 100;
    protected static final int MAXERRORCODE = 106;
    public static final int BADENVDIR = 101;
    public static final int CREATEENVDIR = 102;
    public static final int DBALREADYOPEN = 103;
    public static final int DBCORRUPT = 104;
    public static final int BADMAGIC = 105;
    public static final int HEADERCORRUPT = 106;
    protected static final String[] errorMessage = new String[]{"not used", "There is a problem with the Berkeley DB environement directory", "The Berkeley DB environment directory is not a directory", "An attempt has been made to reopen an already open database", "The database is corrupt", "Did not find the correct magic number in the database configuration", "The database header is corrupt"};

    public BDBException(int n) {
        if (100 <= n && n <= 106) {
            this.errorCode = n;
        } else {
            this.errorCode = 9;
            this.otherCode = n;
        }
    }

    public BDBException(Exception exception) {
        super(exception);
    }

    public BDBException(int n, Exception exception) {
        this.nestedException = exception;
        if (100 <= n && n <= 106) {
            this.errorCode = n;
        } else {
            this.errorCode = 9;
            this.otherCode = n;
        }
    }

    public String toString() {
        String string = 100 <= this.errorCode && this.errorCode <= 106 ? "RDF Error code:" + Integer.toString(this.errorCode) + " " + errorMessage[this.errorCode - 100] : super.toString();
        return string;
    }
}

