/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.bean;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.logger.LogKitLoggerManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.Constants;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.commandline.CommandLineContext;
import org.apache.cocoon.environment.commandline.FileSavingEnvironment;
import org.apache.cocoon.environment.commandline.LinkSamplingEnvironment;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.NetUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Priority;

public class CocoonWrapper {
    protected static final String DEFAULT_USER_AGENT = Constants.COMPLETE_NAME;
    protected static final String DEFAULT_ACCEPT = "text/html, */*";
    private String contextDir = "./webapp";
    private String configFile = null;
    private String workDir = "./work";
    private String logKit = null;
    protected String logger = null;
    private String userAgent = DEFAULT_USER_AGENT;
    private String accept = "text/html, */*";
    private List classList = new ArrayList();
    private File context;
    private File work;
    private File conf;
    private CommandLineContext cliContext;
    private Cocoon cocoon;
    protected static Logger log;
    private Map attributes = new HashMap();
    private HashMap empty = new HashMap();
    private boolean initialized = false;
    static /* synthetic */ Class class$org$apache$cocoon$bean$CocoonWrapper;

    public void initialize() throws Exception {
        this.setLogLevel("ERROR");
        this.context = this.getDir(this.contextDir, "context");
        this.work = this.getDir(this.workDir, "working");
        this.conf = CocoonWrapper.getConfigurationFile(this.context, this.configFile);
        try {
            DefaultContext appContext = new DefaultContext();
            appContext.put((Object)"class-loader", (Object)(class$org$apache$cocoon$bean$CocoonWrapper == null ? (class$org$apache$cocoon$bean$CocoonWrapper = CocoonWrapper.class$("org.apache.cocoon.bean.CocoonWrapper")) : class$org$apache$cocoon$bean$CocoonWrapper).getClassLoader());
            this.cliContext = new CommandLineContext(this.contextDir);
            this.cliContext.enableLogging(log);
            appContext.put((Object)"environment-context", (Object)this.cliContext);
            LogKitLoggerManager logKitLoggerManager = new LogKitLoggerManager(Hierarchy.getDefaultHierarchy());
            logKitLoggerManager.enableLogging(log);
            if (this.logKit != null) {
                FileInputStream fis = new FileInputStream(this.logKit);
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                Configuration logKitConf = builder.build((InputStream)fis);
                DefaultContext subcontext = new DefaultContext((Context)appContext);
                subcontext.put((Object)"context-root", (Object)this.contextDir);
                logKitLoggerManager.contextualize((Context)subcontext);
                logKitLoggerManager.configure(logKitConf);
                log = this.logger != null ? logKitLoggerManager.getLoggerForCategory(this.logger) : logKitLoggerManager.getLoggerForCategory("cocoon");
            }
            appContext.put((Object)"classpath", (Object)CocoonWrapper.getClassPath(this.contextDir));
            appContext.put((Object)"work-directory", (Object)this.work);
            appContext.put((Object)"upload-directory", (Object)(this.contextDir + "upload-dir"));
            File cacheDir = this.getDir(this.workDir + File.separator + "cache-dir", "cache");
            appContext.put((Object)"cache-directory", (Object)cacheDir);
            appContext.put((Object)"config-url", (Object)this.conf.toURL());
            appContext.put((Object)"default-encoding", (Object)"ISO-8859-1");
            this.loadClasses(this.classList);
            this.cocoon = new Cocoon();
            ContainerUtil.enableLogging((Object)this.cocoon, (Logger)log);
            ContainerUtil.contextualize((Object)this.cocoon, (Context)appContext);
            this.cocoon.setLoggerManager((LoggerManager)logKitLoggerManager);
            ContainerUtil.initialize((Object)this.cocoon);
        }
        catch (Exception e) {
            log.fatalError("Exception caught", (Throwable)e);
            throw e;
        }
        this.initialized = true;
    }

    protected ExcaliburComponentManager getComponentManager() {
        return this.cocoon.getComponentManager();
    }

    private static File getConfigurationFile(File dir, String configFile) throws IOException {
        File conf;
        if (configFile == null) {
            conf = CocoonWrapper.tryConfigurationFile(dir + File.separator + "cocoon.xconf");
            if (conf == null) {
                conf = CocoonWrapper.tryConfigurationFile(dir + File.separator + "WEB-INF" + File.separator + "cocoon.xconf");
            }
            if (conf == null) {
                conf = CocoonWrapper.tryConfigurationFile(System.getProperty("user.dir") + File.separator + "cocoon.xconf");
            }
            if (conf == null) {
                conf = CocoonWrapper.tryConfigurationFile("/usr/local/etc/cocoon.xconf");
            }
        } else {
            conf = new File(configFile);
            if (!conf.exists()) {
                conf = new File(dir, configFile);
            }
        }
        if (conf == null) {
            log.error("Could not find the configuration file.");
            throw new FileNotFoundException("The configuration file could not be found.");
        }
        return conf;
    }

    private static File tryConfigurationFile(String filename) {
        File conf;
        if (log.isDebugEnabled()) {
            log.debug("Trying configuration file at: " + filename);
        }
        if ((conf = new File(filename)).canRead()) {
            return conf;
        }
        return null;
    }

    private File getDir(String dir, String type) throws IOException {
        File d;
        if (log.isDebugEnabled()) {
            log.debug("Getting handle to " + type + " directory '" + dir + "'");
        }
        if (!(d = new File(dir)).exists() && !d.mkdirs()) {
            log.error("Error creating " + type + " directory '" + d + "'");
            throw new IOException("Error creating " + type + " directory '" + d + "'");
        }
        if (!d.isDirectory()) {
            log.error("'" + d + "' is not a directory.");
            throw new IOException("'" + d + "' is not a directory.");
        }
        if (!d.canRead() || !d.canWrite()) {
            log.error("Directory '" + d + "' is not readable/writable");
            throw new IOException("Directory '" + d + "' is not readable/writable");
        }
        return d;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected void loadClasses(List classList) {
        if (classList != null) {
            Iterator i = classList.iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Trying to load class: " + className);
                    }
                    ClassUtils.loadClass(className).newInstance();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Could not force-load class: " + className, (Throwable)e);
                }
            }
        }
    }

    public void setLogKit(String logKit) {
        this.logKit = logKit;
    }

    public void setLogLevel(String logLevel) {
        Priority priority = Priority.getPriorityForName((String)logLevel);
        Hierarchy.getDefaultHierarchy().setDefaultPriority(priority);
        log = new LogKitLogger(Hierarchy.getDefaultHierarchy().getLoggerFor(""));
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getLoggerName() {
        return this.logger;
    }

    public void setContextDir(String contextDir) {
        this.contextDir = contextDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setAgentOptions(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setAcceptOptions(String accept) {
        this.accept = accept;
    }

    public void addLoadedClass(String className) {
        this.classList.add(className);
    }

    public void addLoadedClasses(List classList) {
        this.classList.addAll(classList);
    }

    public void processURI(String uri, OutputStream outputStream) throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        log.info("Processing URI: " + uri);
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        String deparameterizedURI = NetUtils.deparameterize(uri, parameters);
        parameters.put("user-agent", this.userAgent);
        parameters.put("accept", this.accept);
        int status = this.getPage(deparameterizedURI, 0L, parameters, null, null, outputStream);
        if (status >= 400) {
            throw new ProcessingException("Resource not found: " + status);
        }
    }

    public void dispose() {
        if (this.initialized) {
            this.initialized = false;
            ContainerUtil.dispose((Object)this.cocoon);
            this.cocoon = null;
            if (log.isDebugEnabled()) {
                log.debug("Disposed");
            }
        }
    }

    protected Collection getLinks(String deparameterizedURI, Map parameters) throws Exception {
        parameters.put("user-agent", this.userAgent);
        parameters.put("accept", this.accept);
        LinkSamplingEnvironment env = new LinkSamplingEnvironment(deparameterizedURI, this.context, this.attributes, parameters, this.cliContext, log);
        this.processLenient(env);
        return env.getLinks();
    }

    protected int getPage(String deparameterizedURI, long lastModified, Map parameters, Map links, List gatheredLinks, OutputStream stream) throws Exception {
        parameters.put("user-agent", this.userAgent);
        parameters.put("accept", this.accept);
        FileSavingEnvironment env = new FileSavingEnvironment(deparameterizedURI, lastModified, this.context, this.attributes, parameters, links, gatheredLinks, this.cliContext, stream, log);
        this.cocoon.process(env);
        int status = env.getStatus();
        if (!env.isModified()) {
            status = -1;
        }
        return status;
    }

    protected String getType(String deparameterizedURI, Map parameters) throws Exception {
        parameters.put("user-agent", this.userAgent);
        parameters.put("accept", this.accept);
        FileSavingEnvironment env = new FileSavingEnvironment(deparameterizedURI, this.context, this.attributes, parameters, this.empty, null, this.cliContext, new NullOutputStream(), log);
        this.processLenient(env);
        return env.getContentType();
    }

    private boolean processLenient(Environment env) throws Exception {
        try {
            this.cocoon.process(env);
        }
        catch (ProcessingException pe) {
            return false;
        }
        return true;
    }

    protected static String getClassPath(String context) {
        StringBuffer buildClassPath = new StringBuffer();
        String classDir = context + "/WEB-INF/classes";
        buildClassPath.append(classDir);
        File root = new File(context + "/WEB-INF/lib");
        if (root.isDirectory()) {
            Object[] libraries = root.listFiles();
            Arrays.sort(libraries);
            int i = 0;
            while (i < libraries.length) {
                if (((File)libraries[i]).getAbsolutePath().endsWith(".jar")) {
                    buildClassPath.append(File.pathSeparatorChar).append(IOUtils.getFullFilename((File)libraries[i]));
                }
                ++i;
            }
        }
        buildClassPath.append(File.pathSeparatorChar).append(System.getProperty("java.class.path"));
        if (log.isDebugEnabled()) {
            log.debug("Context classpath: " + buildClassPath);
        }
        return buildClassPath.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

