/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.components.pipeline.impl.AbstractCachingProcessingPipeline;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.excalibur.source.SourceValidity;

public class CachingPointProcessingPipeline
extends AbstractCachingProcessingPipeline {
    protected ArrayList isCachePoint = new ArrayList();
    protected ArrayList xmlSerializerArray = new ArrayList();
    protected boolean nextIsCachePoint = false;
    protected String autoCachingPointSwitch;
    protected boolean autoCachingPoint = true;

    public void parameterize(Parameters config) throws ParameterException {
        super.parameterize(config);
        this.autoCachingPointSwitch = config.getParameter("autoCachingPoint", null);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Auto caching-point is set to = '" + this.autoCachingPointSwitch + "'");
        }
        if (this.autoCachingPointSwitch == null) {
            this.autoCachingPoint = true;
            return;
        }
        this.autoCachingPoint = this.autoCachingPointSwitch.toLowerCase().equals("on");
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        String pipelinehint;
        block4: {
            super.setGenerator(role, source, param, hintParam);
            pipelinehint = null;
            try {
                pipelinehint = hintParam.getParameter("caching-point", null);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("generator caching-point pipeline-hint is set to: " + pipelinehint);
                }
            }
            catch (Exception ex) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                this.getLogger().warn("caching-point hint Exception, pipeline-hint ignored: " + ex);
            }
        }
        if ("true".equals(pipelinehint)) {
            this.nextIsCachePoint = true;
        }
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        String pipelinehint;
        block4: {
            super.addTransformer(role, source, param, hintParam);
            pipelinehint = null;
            try {
                pipelinehint = hintParam.getParameter("caching-point", null);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("transformer caching-point pipeline-hint is set to: " + pipelinehint);
                }
            }
            catch (Exception ex) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                this.getLogger().warn("caching-point hint Exception, pipeline-hint ignored: " + ex);
            }
        }
        this.isCachePoint.add(new Boolean(this.nextIsCachePoint));
        this.nextIsCachePoint = false;
        if ("true".equals(pipelinehint)) {
            this.nextIsCachePoint = true;
        }
    }

    public void informBranchPoint() {
        if (this.generator == null) {
            return;
        }
        if (!this.autoCachingPoint) {
            return;
        }
        this.nextIsCachePoint = true;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Informed Pipeline of branch point");
        }
    }

    protected void cacheResults(Environment environment, OutputStream os) throws Exception {
        if (this.toCacheKey != null) {
            if (this.cacheCompleteResponse) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Cached: caching complete response; pSisze" + this.toCacheKey.size() + " Key " + this.toCacheKey);
                }
                CachedResponse response = new CachedResponse(this.toCacheSourceValidities, ((CachingOutputStream)os).getContent());
                this.cache.store(this.toCacheKey.copy(), response);
                this.toCacheKey.removeUntilCachePoint();
                if (this.toCacheKey.size() > 0) {
                    SourceValidity[] copy = new SourceValidity[this.toCacheKey.size()];
                    System.arraycopy(this.toCacheSourceValidities, 0, copy, 0, copy.length);
                    this.toCacheSourceValidities = copy;
                }
            }
            if (this.toCacheKey.size() > 0) {
                ListIterator itt = this.xmlSerializerArray.listIterator(this.xmlSerializerArray.size());
                while (itt.hasPrevious()) {
                    XMLSerializer serializer = (XMLSerializer)itt.previous();
                    CachedResponse response = new CachedResponse(this.toCacheSourceValidities, (byte[])serializer.getSAXFragment());
                    this.cache.store(this.toCacheKey.copy(), response);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Caching results for the following key: " + this.toCacheKey);
                    }
                    this.toCacheKey.removeUntilCachePoint();
                    if (this.toCacheKey.size() == 0) break;
                    SourceValidity[] copy = new SourceValidity[this.toCacheKey.size()];
                    System.arraycopy(this.toCacheSourceValidities, 0, copy, 0, copy.length);
                    this.toCacheSourceValidities = copy;
                }
            }
        }
    }

    protected ComponentCacheKey newComponentCacheKey(int type, String role, Serializable key) {
        boolean cachePoint = false;
        if (type == 3) {
            cachePoint = (Boolean)this.isCachePoint.get(this.firstNotCacheableTransformerIndex);
        } else if (type == 5) {
            cachePoint = this.nextIsCachePoint;
        }
        return new ComponentCacheKey(type, role, key, cachePoint);
    }

    protected void connectCachingPipeline(Environment environment) throws ProcessingException {
        try {
            XMLSerializer localXMLSerializer = null;
            XMLSerializer cachePointXMLSerializer = null;
            if (!this.cacheCompleteResponse) {
                localXMLSerializer = this.xmlSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
            }
            if (this.cachedResponse == null) {
                XMLConsumer next;
                XMLProducer prev = this.generator;
                int cacheableTransformerCount = this.firstNotCacheableTransformerIndex;
                int currentTransformerIndex = 0;
                Iterator itt = this.transformers.iterator();
                while (itt.hasNext()) {
                    next = (XMLConsumer)itt.next();
                    if (cacheableTransformerCount > 0 && this.isCachePoint.get(currentTransformerIndex) != null && ((Boolean)this.isCachePoint.get(currentTransformerIndex)).booleanValue()) {
                        cachePointXMLSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                        next = new XMLTeePipe(next, cachePointXMLSerializer);
                        this.xmlSerializerArray.add(cachePointXMLSerializer);
                    }
                    if (localXMLSerializer != null) {
                        if (cacheableTransformerCount == 0) {
                            next = new XMLTeePipe(next, localXMLSerializer);
                            this.xmlSerializerArray.add(localXMLSerializer);
                            localXMLSerializer = null;
                        } else {
                            --cacheableTransformerCount;
                        }
                    }
                    this.connect(environment, prev, next);
                    prev = (XMLProducer)((Object)next);
                    ++currentTransformerIndex;
                }
                next = this.lastConsumer;
                if (localXMLSerializer != null) {
                    next = new XMLTeePipe(next, localXMLSerializer);
                    this.xmlSerializerArray.add(localXMLSerializer);
                    localXMLSerializer = null;
                } else if (currentTransformerIndex == this.firstNotCacheableTransformerIndex && this.nextIsCachePoint) {
                    cachePointXMLSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                    next = new XMLTeePipe(next, cachePointXMLSerializer);
                    this.xmlSerializerArray.add(cachePointXMLSerializer);
                }
                this.connect(environment, prev, next);
            } else {
                XMLConsumer next;
                XMLProducer prev = this.xmlDeserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                int cacheableTransformerCount = 0;
                Iterator itt = this.transformers.iterator();
                while (itt.hasNext()) {
                    next = (XMLConsumer)itt.next();
                    if (cacheableTransformerCount >= this.firstProcessedTransformerIndex) {
                        if (cacheableTransformerCount < this.firstNotCacheableTransformerIndex && !(prev instanceof XMLDeserializer) && this.isCachePoint.get(cacheableTransformerCount) != null && ((Boolean)this.isCachePoint.get(cacheableTransformerCount)).booleanValue()) {
                            cachePointXMLSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                            next = new XMLTeePipe(next, cachePointXMLSerializer);
                            this.xmlSerializerArray.add(cachePointXMLSerializer);
                        }
                        if (localXMLSerializer != null && !(prev instanceof XMLDeserializer) && cacheableTransformerCount == this.firstNotCacheableTransformerIndex) {
                            next = new XMLTeePipe(next, localXMLSerializer);
                            this.xmlSerializerArray.add(localXMLSerializer);
                            localXMLSerializer = null;
                        }
                        this.connect(environment, prev, next);
                        prev = (XMLProducer)((Object)next);
                    }
                    ++cacheableTransformerCount;
                }
                next = this.lastConsumer;
                if (localXMLSerializer != null && !(prev instanceof XMLDeserializer)) {
                    next = new XMLTeePipe(next, localXMLSerializer);
                    this.xmlSerializerArray.add(localXMLSerializer);
                    localXMLSerializer = null;
                } else if (this.nextIsCachePoint && !(prev instanceof XMLDeserializer) && cacheableTransformerCount == this.firstNotCacheableTransformerIndex) {
                    cachePointXMLSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
                    next = new XMLTeePipe(next, cachePointXMLSerializer);
                    this.xmlSerializerArray.add(cachePointXMLSerializer);
                }
                this.connect(environment, prev, next);
            }
        }
        catch (ComponentException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
    }

    public void recycle() {
        super.recycle();
        Iterator itt = this.xmlSerializerArray.iterator();
        while (itt.hasNext()) {
            this.manager.release((Component)((XMLSerializer)itt.next()));
        }
        this.isCachePoint.clear();
        this.xmlSerializerArray.clear();
        this.nextIsCachePoint = false;
        this.autoCachingPointSwitch = null;
    }
}

