/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class MountNode
extends AbstractProcessingNode
implements Composable {
    private VariableResolver prefix;
    private VariableResolver source;
    private Map processors = new HashMap();
    private TreeProcessor parentProcessor;
    private String language;
    private ComponentManager manager;

    public MountNode(VariableResolver prefix, VariableResolver source, String language, TreeProcessor parentProcessor) {
        this.prefix = prefix;
        this.source = source;
        this.language = language;
        this.parentProcessor = parentProcessor;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        String oldContext;
        String oldURI;
        String oldPrefix;
        TreeProcessor processor;
        block5: {
            block6: {
                Map objectModel = env.getObjectModel();
                String resolvedSource = this.source.resolve(context, objectModel);
                String resolvedPrefix = this.prefix.resolve(context, objectModel);
                if (resolvedSource.length() == 0) {
                    throw new ProcessingException("Source of mount statement is empty");
                }
                processor = this.getProcessor(resolvedSource);
                oldPrefix = env.getURIPrefix();
                oldURI = env.getURI();
                oldContext = env.getContext();
                try {
                    env.changeContext(resolvedPrefix, resolvedSource);
                    if (!context.isBuildingPipelineOnly()) break block5;
                    ProcessingPipeline pp = processor.buildPipeline(env);
                    if (pp == null) break block6;
                    context.setProcessingPipeline(pp);
                    boolean bl = true;
                    Object var13_14 = null;
                    env.setContext(oldPrefix, oldURI, oldContext);
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    env.setContext(oldPrefix, oldURI, oldContext);
                    throw throwable;
                }
            }
            boolean bl = false;
            Object var13_15 = null;
            env.setContext(oldPrefix, oldURI, oldContext);
            return bl;
        }
        boolean bl = processor.process(env);
        Object var13_16 = null;
        env.setContext(oldPrefix, oldURI, oldContext);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TreeProcessor getProcessor(String source) throws Exception {
        TreeProcessor processor = (TreeProcessor)this.processors.get(source);
        if (processor == null) {
            String actualSource = source.charAt(source.length() - 1) == '/' ? source + "sitemap.xmap" : source;
            SourceResolver resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            try {
                Source src = resolver.resolveURI(actualSource);
                try {
                    processor = this.parentProcessor.createChildProcessor(this.manager, this.language, src);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    resolver.release(src);
                    throw throwable;
                }
                resolver.release(src);
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.manager.release((Component)resolver);
                throw throwable;
            }
            this.manager.release((Component)resolver);
            this.processors.put(source, processor);
        }
        return processor;
    }

    public void dispose() {
        Iterator iter = this.processors.values().iterator();
        while (iter.hasNext()) {
            ((TreeProcessor)iter.next()).dispose();
        }
    }
}

