/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.util.PostInputStream;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamGenerator
extends ServiceableGenerator {
    public static final String FORM_NAME = "form-name";
    private InputSource inputSource;

    public void recycle() {
        super.recycle();
        this.inputSource = null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        SAXParser parser = null;
        int len = 0;
        String contentType = null;
        Request request = ObjectModelHelper.getRequest(this.objectModel);
        try {
            try {
                String charset;
                contentType = request.getContentType();
                if (contentType == null) {
                    contentType = this.parameters.getParameter("defaultContentType", null);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("no Content-Type header - using contentType parameter: " + contentType);
                    }
                    if (contentType == null) {
                        throw new IOException("both Content-Type header and defaultContentType parameter are not set");
                    }
                }
                if (contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart/form-data")) {
                    void var7_13;
                    String parameter = this.parameters.getParameter(FORM_NAME, null);
                    if (parameter == null) {
                        throw new ProcessingException("StreamGenerator expects a sitemap parameter called 'form-name' for handling form data");
                    }
                    Object xmlObject = request.get(parameter);
                    Object var7_10 = null;
                    if (xmlObject instanceof String) {
                        StringReader stringReader = new StringReader((String)xmlObject);
                    } else {
                        if (!(xmlObject instanceof Part)) throw new ProcessingException("Unknown request object encountered named " + parameter + " : " + xmlObject);
                        InputStreamReader inputStreamReader = new InputStreamReader(((Part)xmlObject).getInputStream());
                    }
                    this.inputSource = new InputSource((Reader)var7_13);
                } else {
                    if (!contentType.startsWith("text/plain") && !contentType.startsWith("text/xml") && !contentType.startsWith("application/xml")) throw new IOException("Unexpected getContentType(): " + request.getContentType());
                    HttpServletRequest httpRequest = (HttpServletRequest)this.objectModel.get("httprequest");
                    if (httpRequest == null) {
                        throw new ProcessingException("This feature is only available in an http environment.");
                    }
                    len = request.getContentLength();
                    if (len <= 0) throw new IOException("getContentLen() == 0");
                    PostInputStream anStream = new PostInputStream((InputStream)httpRequest.getInputStream(), len);
                    this.inputSource = new InputSource(anStream);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("processing stream ContentType=" + contentType + " ContentLen=" + len);
                }
                if ((charset = this.getCharacterEncoding(request, contentType)) != null) {
                    this.inputSource.setEncoding(charset);
                }
                parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                parser.parse(this.inputSource, (ContentHandler)((Object)this.xmlConsumer));
            }
            catch (IOException e) {
                this.getLogger().error("StreamGenerator.generate()", (Throwable)e);
                throw new ResourceNotFoundException("StreamGenerator could not find resource", e);
            }
            catch (SAXException e) {
                this.getLogger().error("StreamGenerator.generate()", (Throwable)e);
                throw e;
            }
            catch (Exception exception) {
                this.getLogger().error("Could not get parser", (Throwable)exception);
                throw new ProcessingException("Exception in StreamGenerator.generate()", exception);
            }
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            this.manager.release(parser);
            throw throwable;
        }
        this.manager.release((Object)parser);
    }

    public String getCharacterEncoding(Request req, String contentType) {
        String charencoding = null;
        String charset = "charset=";
        if (contentType == null) {
            return null;
        }
        int idx = contentType.indexOf(charset);
        if (idx == -1) {
            return null;
        }
        try {
            charencoding = req.getCharacterEncoding();
            if (charencoding != null) {
                this.getLogger().debug("charset from container: " + charencoding);
                charencoding = charencoding.trim();
                if (charencoding.length() > 2 && charencoding.startsWith("\"") && charencoding.endsWith("\"")) {
                    charencoding = charencoding.substring(1, charencoding.length() - 1);
                }
                this.getLogger().debug("charset from container clean: " + charencoding);
                return charencoding;
            }
            return this.extractCharset(contentType, idx);
        }
        catch (Throwable e) {
            return this.extractCharset(contentType, idx);
        }
    }

    protected String extractCharset(String contentType, int idx) {
        String charencoding = null;
        String charset = "charset=";
        this.getLogger().debug("charset from extractCharset");
        charencoding = contentType.substring(idx + charset.length());
        int idxEnd = charencoding.indexOf(";");
        if (idxEnd != -1) {
            charencoding = charencoding.substring(0, idxEnd);
        }
        if ((charencoding = charencoding.trim()).length() > 2 && charencoding.startsWith("\"") && charencoding.endsWith("\"")) {
            charencoding = charencoding.substring(1, charencoding.length() - 1);
        }
        this.getLogger().debug("charset from extractCharset: " + charencoding);
        return charencoding.trim();
    }
}

