/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.messaging.MessageHandler;

public class AWTFontMetrics {
    public static final int FONT_SIZE = 1;
    public static final int FONT_FACTOR = 1000000;
    private int[] width = null;
    private int xHeight = 0;
    private Font f1 = null;
    private String family = "";
    private int style = 0;
    private float size = 0.0f;
    private FontMetrics fmt = null;
    Graphics2D graphics;
    private Map embedFontList = null;
    private Map fontCache = null;

    public AWTFontMetrics(Graphics2D graphics) {
        this.graphics = graphics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Font createFont(String family, int style, int size) {
        Font cachedFont;
        URL fontURL;
        block10: {
            fontURL = null;
            if (this.embedFontList != null) {
                fontURL = (URL)this.embedFontList.get(String.valueOf(family) + style);
            }
            if (fontURL == null) {
                return new Font(family, style, size);
            }
            if (this.fontCache == null) {
                this.fontCache = new HashMap();
            }
            if ((cachedFont = (Font)this.fontCache.get(fontURL.toExternalForm())) != null) return cachedFont.deriveFont(style, size);
            InputStream fontStream = null;
            try {
                try {
                    MessageHandler.logln("Create embedded AWT font from stream " + fontURL.toExternalForm());
                    fontStream = fontURL.openStream();
                    cachedFont = Font.createFont(0, fontStream);
                }
                catch (Throwable th) {
                    MessageHandler.error("Failed to create embedded AWT font " + fontURL.toExternalForm() + ": " + th.toString());
                    cachedFont = new Font("Dialog", style, size);
                }
                Object var8_8 = null;
                if (fontStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (fontStream == null) throw throwable;
                try {
                    fontStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            fontStream.close();
        }
        this.fontCache.put(fontURL.toExternalForm(), cachedFont);
        return cachedFont.deriveFont(style, size);
    }

    public int getAscender(String family, int style, int size) {
        this.setFont(family, style, size);
        int realAscent = this.fmt.getAscent() - (this.fmt.getDescent() + this.fmt.getLeading());
        return 1000000 * realAscent;
    }

    public int getCapHeight(String family, int style, int size) {
        return this.getAscender(family, style, size);
    }

    public int getDescender(String family, int style, int size) {
        this.setFont(family, style, size);
        return -1000000 * this.fmt.getDescent();
    }

    public Font getFont(String family, int style, int size) {
        this.setFont(family, style, size);
        return this.f1;
    }

    public int[] getWidths(String family, int style, int size) {
        if (this.width == null) {
            this.width = new int[256];
        }
        this.setFont(family, style, size);
        int i = 0;
        while (i < 256) {
            this.width[i] = 1000000 * this.fmt.charWidth(i);
            ++i;
        }
        return this.width;
    }

    public int getXHeight(String family, int style, int size) {
        this.setFont(family, style, size);
        return 1000000 * this.xHeight;
    }

    public void setEmbedFont(String family, int style, URL fontURL) {
        if (this.embedFontList == null) {
            this.embedFontList = new HashMap();
        }
        this.embedFontList.put(String.valueOf(family) + style, fontURL);
    }

    private boolean setFont(String family, int style, int size) {
        boolean changed = false;
        int s = (int)((float)size / 1000.0f);
        if (this.f1 == null) {
            this.f1 = this.createFont(family, style, s);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            changed = true;
        } else if (this.style != style || !this.family.equals(family) || this.size != (float)s) {
            this.f1 = family.equals(this.family) ? this.f1.deriveFont(style, s) : this.createFont(family, style, s);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            changed = true;
        }
        if (changed) {
            TextLayout layout = new TextLayout("m", this.f1, this.graphics.getFontRenderContext());
            Rectangle2D rect = layout.getBounds();
            this.xHeight = (int)rect.getHeight();
        }
        this.family = family;
        this.style = style;
        this.size = s;
        return changed;
    }

    public int width(int i, String family, int style, int size) {
        this.setFont(family, style, size);
        char[] ac = new char[]{(char)i};
        double dWidth = this.fmt.getStringBounds(ac, 0, 1, (Graphics)this.graphics).getWidth() * 1000000.0;
        if (i <= 32) {
            dWidth *= 1.4;
        }
        return (int)dWidth;
    }
}

