/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.acting.AbstractDatabaseAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class DatabaseSelectAction
extends AbstractDatabaseAction
implements ThreadSafe {
    private static final Map selectStatements = new HashMap();

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        DataSourceComponent datasource = null;
        Connection conn = null;
        int currentIndex = 0;
        boolean reloadable = true;
        if (this.settings.containsKey((Object)"reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get((Object)"reloadable"));
        }
        try {
            Configuration conf = this.getConfiguration(param.getParameter("descriptor", (String)this.settings.get((Object)"descriptor")), resolver, param.getParameterAsBoolean("reloadable", reloadable));
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            Configuration[] keys = conf.getChild("table").getChild("keys").getChildren("key");
            Configuration[] values = conf.getChild("table").getChild("values").getChildren("value");
            Statement statement = null;
            ResultSet rset = null;
            boolean result = false;
            int i = 0;
            while (i < keys.length) {
                String parameter = keys[i].getAttribute("param");
                Object value = request.getParameter(parameter);
                if (StringUtils.isEmpty((String)value)) {
                    if (statement == null) {
                        String query = this.getSelectQuery(conf);
                        datasource = this.getDataSource(conf);
                        conn = datasource.getConnection();
                        statement = conn.prepareStatement(query);
                        currentIndex = 1;
                        int j = 0;
                        while (j < keys.length) {
                            this.setColumn((PreparedStatement)statement, currentIndex, request, keys[j]);
                            ++j;
                            ++currentIndex;
                        }
                        rset = statement.executeQuery();
                        result = rset.next();
                    }
                    if (result) {
                        value = this.getColumn(rset, request, keys[i]);
                    }
                }
                if (value != null) {
                    request.setAttribute(parameter, (Object)value.toString());
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < values.length) {
                String parameter = values[i2].getAttribute("param");
                Object value = request.getParameter(parameter);
                if (StringUtils.isEmpty((String)value)) {
                    if (statement == null) {
                        String query = this.getSelectQuery(conf);
                        datasource = this.getDataSource(conf);
                        conn = datasource.getConnection();
                        statement = conn.prepareStatement(query);
                        currentIndex = 1;
                        int j = 0;
                        while (j < keys.length) {
                            this.setColumn((PreparedStatement)statement, currentIndex, request, keys[j]);
                            ++j;
                            ++currentIndex;
                        }
                        rset = statement.executeQuery();
                        result = rset.next();
                    }
                    if (result) {
                        value = this.getColumn(rset, request, values[i2]);
                    }
                }
                if (value != null) {
                    request.setAttribute(parameter, (Object)value.toString());
                }
                ++i2;
            }
            if (statement != null) {
                statement.close();
            }
            Map map = AbstractAction.EMPTY_MAP;
            return map;
        }
        catch (Exception e) {
            throw new ProcessingException("Could not prepare statement :position = " + currentIndex, (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                }
            }
            if (datasource != null) {
                this.dbselector.release(datasource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectQuery(Configuration conf) throws ConfigurationException {
        String query = null;
        Map map = selectStatements;
        synchronized (map) {
            query = (String)selectStatements.get(conf);
            if (query == null) {
                Configuration table = conf.getChild("table");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                Configuration[] values = table.getChild("values").getChildren("value");
                StringBuffer queryBuffer = new StringBuffer("SELECT ");
                queryBuffer.append(this.buildList(keys, 0));
                queryBuffer.append(this.buildList(values, keys.length));
                queryBuffer.append(" FROM ");
                queryBuffer.append(table.getAttribute("name"));
                queryBuffer.append(" WHERE ");
                queryBuffer.append(this.buildList(keys, " AND "));
                query = queryBuffer.toString();
                selectStatements.put(conf, query);
            }
        }
        return query;
    }
}

