/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.cocoon.CascadingIOException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

class Cell {
    private HSSFCell _cell;
    private int _celltype;
    private Locale locale;

    Cell(HSSFCell cell, int cellType) {
        this._cell = cell;
        this._celltype = cellType;
        this._cell.setEncoding((short)1);
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    void setContent(String content) throws IOException {
        if (this._cell.getCellType() == 0) {
            try {
                if (this._celltype == 40) {
                    NumberFormat form = null;
                    form = this.locale == null ? NumberFormat.getInstance() : NumberFormat.getInstance(this.locale);
                    this._cell.setCellValue(form.parse(content).doubleValue());
                }
                this._cell.setCellValue((double)Integer.parseInt(content));
            }
            catch (NumberFormatException e) {
                throw new CascadingIOException("Invalid value for a numeric cell: " + content, (Throwable)e);
            }
            catch (ParseException e) {
                throw new CascadingIOException("Invalid value for a numeric cell: " + content, (Throwable)e);
            }
        } else if (this._cell.getCellType() == 1) {
            this._cell.setCellValue(content);
        } else if (this._cell.getCellType() == 2) {
            this._cell.setCellFormula(content.toUpperCase().substring(1));
        }
    }

    void setStyle(HSSFCellStyle style) {
        if (style != null) {
            this._cell.setCellStyle(style);
        }
    }

    int getCellType() {
        return this._cell.getCellType();
    }

    String getStringValue() {
        return this._cell.getStringCellValue();
    }

    double getNumericValue() {
        return this._cell.getNumericCellValue();
    }
}

