/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

class Workbook {
    private HSSFWorkbook _workbook = new HSSFWorkbook();
    private int _sheet_index = 0;
    private static final int REPEAT_CAPACITY = 91;
    private Map _repeat = new HashMap(91);

    Workbook() {
    }

    HSSFDataFormat createDataFormat() {
        return this._workbook.createDataFormat();
    }

    Object getValidate(String format, short value) {
        if (!this._repeat.containsKey(format)) {
            this._repeat.put(format, new Short(value));
        }
        return this._repeat.get(format);
    }

    String getNextName() {
        return "Sheet" + this._sheet_index++;
    }

    HSSFSheet createSheet(String name) {
        return this._workbook.createSheet(name);
    }

    int getPhysicalIndex(String name) {
        return this._workbook.getSheetIndex(name);
    }

    void renameSheet(int index, String name) {
        this._workbook.setSheetName(index, name, (short)1);
    }

    HSSFCellStyle createStyle() {
        HSSFCellStyle style = this._workbook.createCellStyle();
        return style;
    }

    HSSFFont createFont() {
        HSSFFont font = this._workbook.createFont();
        return font;
    }

    HSSFWorkbook getWorkbook() {
        return this._workbook;
    }

    void write(POIFSFileSystem filesystem) throws IOException {
        filesystem.createDocument((InputStream)new ByteArrayInputStream(this._workbook.getBytes()), "Workbook");
    }
}

