/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.mpool;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.StaticBucketMap;
import org.apache.excalibur.event.Sink;
import org.apache.excalibur.event.command.RepeatedCommand;
import org.apache.excalibur.mpool.ManagablePool;
import org.apache.excalibur.mpool.ObjectFactory;
import org.apache.excalibur.mpool.Pool;
import org.apache.excalibur.mpool.PoolManager;
import org.apache.excalibur.mpool.VariableSizePool;

public class DefaultPoolManager
implements PoolManager {
    private final Random m_keyGenerator;
    private final Map m_keyMap = new StaticBucketMap();
    private final Map m_factoryMap = new StaticBucketMap();

    public DefaultPoolManager() {
        this(null);
    }

    public DefaultPoolManager(Sink commandSink) {
        this.m_keyGenerator = new Random();
        if (null != commandSink) {
            try {
                commandSink.enqueue((Object)new PoolManagerCommand(this.m_keyMap));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Pool getManagedPool(ObjectFactory factory, int initialEntries) throws Exception {
        ManagablePool pool = (ManagablePool)this.m_factoryMap.get(factory);
        if (null == pool) {
            long poolKey = this.getKey();
            pool = new VariableSizePool(factory, initialEntries, poolKey);
            this.m_keyMap.put(pool, new Long(poolKey));
            this.m_factoryMap.put(factory, pool);
        }
        return pool;
    }

    private final long getKey() {
        return this.m_keyGenerator.nextLong();
    }

    private static final class PoolManagerCommand
    implements RepeatedCommand {
        private final Map m_map;
        private final int m_min = 4;
        private final int m_max = 256;
        private final int m_grow = 4;

        protected PoolManagerCommand(Map map) {
            this.m_map = map;
        }

        public long getDelayInterval() {
            return 10000L;
        }

        public long getRepeatInterval() {
            return 10000L;
        }

        public int getNumberOfRepeats() {
            return 0;
        }

        public void execute() throws Exception {
            Iterator i = this.m_map.keySet().iterator();
            while (i.hasNext()) {
                long key;
                ManagablePool pool = (ManagablePool)i.next();
                int size = pool.size(key = ((Long)this.m_map.get(pool)).longValue());
                if (size < 4) {
                    pool.grow(4, key);
                }
                if (size <= 256) continue;
                pool.shrink(4, key);
            }
        }
    }
}

