/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.search.lucene.analysis;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import fr.gouv.culture.sdx.utils.SAXUtils;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.constants.Node;

/**
 * An abstract implementation of a SDX analyzer.
 *
 * <p>
 * It handles properly the logging and configuring
 * methods. For configuration, it does nothing.
 */
public abstract class AbstractAnalyzer extends org.apache.lucene.analysis.Analyzer implements Analyzer {

    /** Avalon super.getLog() to write information. */
    protected transient org.apache.avalon.framework.logger.Logger logger;
    
    protected abstract String getAnalyzerType();
    /**
     * Sets the super.getLog().
     *
     * @param   logger     The super.getLog() to use.
     */
    public void enableLogging(org.apache.avalon.framework.logger.Logger logger) {
        this.logger = logger;
    }

    /**
     * Configures this analyzer, currently has no function, only in its subclasses.
     */
    public void configure(Configuration configuration) throws ConfigurationException {
    }

	public void toSAX(ContentHandler handler) throws SAXException {
		handler.startElement(Node.Uri.SDX, "analyzer", Utilities.prefixNodeNameSDX("analyzer"),new AttributesImpl());
		
		handler.startElement(Node.Uri.SDX, "type", Utilities.prefixNodeNameSDX("type"),new AttributesImpl());
		SAXUtils.sendElementContent(handler, this.getClass().getName());
		handler.endElement(Node.Uri.SDX, "type", Utilities.prefixNodeNameSDX("type"));
		
        handler.endElement(Node.Uri.SDX, "analyzer", Utilities.prefixNodeNameSDX("analyzer"));
    }

}
