/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.constants.Node;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.sdx.utils.save.Saveable;

/**
 * Created by gVim
 * User: Pierre Dittgen
 * Date: 2 nov 2004
 */
public class POSTGRESQLDatabase extends JDBCDatabase {

	protected final String FIELD_KEY = "sdx_key";

	protected String getTableCreationQuery() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("CREATE TABLE ").append(getTableName());
		buffer.append(" ( ").append(FIELD_ID).append(" VARCHAR(255) NOT NULL,");
		buffer.append(FIELD_PROPERTY_NAME).append(" VARCHAR(255) NOT NULL, ");
	    buffer.append(FIELD_PROPERTY_VALUE).append(" VARCHAR(255) NOT NULL, ");
		buffer.append(FIELD_KEY).append(" SERIAL, ");
		buffer.append("PRIMARY KEY (").append(FIELD_KEY).append("))");

		return buffer.toString();
	}
	
	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		this._xmlizable_objects.put("Database_Type","POSTGRESQLDatabase");
		this._xmlizable_objects.put("JDBC_Table_Name",this.tableName);
		this._xmlizable_objects.put("Data_Source_Identifier",this.dsi);
		return true;
	}

	/** Save the database
	 * @see fr.gouv.culture.sdx.utils.save.Saveable#backup(fr.gouv.culture.sdx.utils.save.SaveParameters)
	 */
	public void backup(SaveParameters save_config) throws SDXException {
		super.backup(save_config);
		if(save_config != null)
			if(save_config.getAttributeAsBoolean(Saveable.ALL_SAVE_ATTRIB,false))
			{
				save_config.setAttribute(Node.Name.TYPE,"POSTGRESQL");
			}
	}

	/**
	 * Overloaded from AbstractJDBCDatabase
	 */
    protected String getCreateIndiciesQuery(String fieldName) {
        return "CREATE INDEX " + getTableName() + '_' + fieldName + "_idx" 
			+ " ON " + getTableName() + " (" + fieldName + ")";
    }

	
	/** 
	 * @see fr.gouv.culture.sdx.utils.database.AbstractJDBCDatabase#getAllEntitiesWithLimitQuery(long, long)
	 * POSTGRESQL implementation
	 * SELECT * FROM &gt;table_name&lt; LIMIT &gt;number&lt; OFFSET &gt;offset&lt; ;
	 */
	protected String getEntriesWithLimitQuery(long offset, long number) {
		String query = "SELECT * FROM " + getTableName();
		query += " LIMIT " + String.valueOf(number) + " OFFSET " + String.valueOf(offset) + ";";
		return query;
	}
	
	/** Restore the database
	 * @see fr.gouv.culture.sdx.utils.save.Saveable#restore(fr.gouv.culture.sdx.utils.save.SaveParameters)
	 */
	public void restore(SaveParameters save_config) throws SDXException {
		super.restore(save_config);
	}
}

