/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.IntList;
import org.apache.poi.util.LittleEndian;

public class IndexRecord
extends Record {
    public static final short sid = 523;
    public static final int DBCELL_CAPACITY = 30;
    public int field_1_zero;
    public int field_2_first_row;
    public int field_3_last_row_add1;
    public int field_4_zero;
    public IntList field_5_dbcells;

    public IndexRecord() {
    }

    public IndexRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public IndexRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 523) {
            throw new RecordFormatException("NOT An Index RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_5_dbcells = new IntList(30);
        this.field_1_zero = LittleEndian.getInt(data, 0 + offset);
        this.field_2_first_row = LittleEndian.getInt(data, 4 + offset);
        this.field_3_last_row_add1 = LittleEndian.getInt(data, 8 + offset);
        this.field_4_zero = LittleEndian.getInt(data, 12 + offset);
        int k = 16;
        while (k < size) {
            this.field_5_dbcells.add(LittleEndian.getInt(data, k + offset));
            k += 4;
        }
    }

    public void setFirstRow(int row) {
        this.field_2_first_row = row;
    }

    public void setLastRowAdd1(int row) {
        this.field_3_last_row_add1 = row;
    }

    public void addDbcell(int cell) {
        if (this.field_5_dbcells == null) {
            this.field_5_dbcells = new IntList();
        }
        this.field_5_dbcells.add(cell);
    }

    public void setDbcell(int cell, int value) {
        this.field_5_dbcells.set(cell, value);
    }

    public int getFirstRow() {
        return this.field_2_first_row;
    }

    public int getLastRowAdd1() {
        return this.field_3_last_row_add1;
    }

    public int getNumDbcells() {
        if (this.field_5_dbcells == null) {
            return 0;
        }
        return this.field_5_dbcells.size();
    }

    public int getDbcellAt(int cellnum) {
        return this.field_5_dbcells.get(cellnum);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[INDEX]\n");
        buffer.append("    .firstrow       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        buffer.append("    .lastrowadd1    = ").append(Integer.toHexString(this.getLastRowAdd1())).append("\n");
        int k = 0;
        while (k < this.getNumDbcells()) {
            buffer.append("    .dbcell_" + k + "       = ").append(Integer.toHexString(this.getDbcellAt(k))).append("\n");
            ++k;
        }
        buffer.append("[/INDEX]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)523);
        LittleEndian.putShort(data, 2 + offset, (short)(16 + this.getNumDbcells() * 4));
        LittleEndian.putInt(data, 4 + offset, 0);
        LittleEndian.putInt(data, 8 + offset, this.getFirstRow());
        LittleEndian.putInt(data, 12 + offset, this.getLastRowAdd1());
        LittleEndian.putInt(data, 16 + offset, 0);
        int k = 0;
        while (k < this.getNumDbcells()) {
            LittleEndian.putInt(data, k * 4 + 20 + offset, this.getDbcellAt(k));
            ++k;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20 + this.getNumDbcells() * 4;
    }

    public short getSid() {
        return 523;
    }

    static {
        sid = (short)523;
        DBCELL_CAPACITY = 30;
    }
}

