/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import java.util.HashSet;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class AncestorContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean setStarted = false;
    private NodePointer currentNodePointer;
    private boolean includeSelf;
    private HashSet visitedNodes = new HashSet();

    public AncestorContext(EvalContext parentContext, boolean includeSelf, NodeTest nodeTest) {
        super(parentContext);
        this.includeSelf = includeSelf;
        this.nodeTest = nodeTest;
    }

    public NodePointer getCurrentNodePointer() {
        return this.currentNodePointer;
    }

    public int getDocumentOrder() {
        return -1;
    }

    public void reset() {
        super.reset();
        this.setStarted = false;
    }

    public boolean setPosition(int position) {
        if (position < this.getCurrentPosition()) {
            this.reset();
        }
        while (this.getCurrentPosition() < position) {
            if (this.nextNode()) continue;
            return false;
        }
        return true;
    }

    public boolean nextNode() {
        while (this.nextIgnoreDuplicates()) {
            NodePointer location = this.getCurrentNodePointer();
            if (this.visitedNodes.contains(location)) continue;
            this.visitedNodes.add(location.clone());
            ++this.position;
            return true;
        }
        return false;
    }

    private boolean nextIgnoreDuplicates() {
        if (!this.setStarted) {
            this.setStarted = true;
            this.currentNodePointer = this.parentContext.getCurrentNodePointer();
            if (this.includeSelf && this.currentNodePointer.testNode(this.nodeTest)) {
                return true;
            }
        }
        do {
            this.currentNodePointer = this.currentNodePointer.getParent();
            if (this.currentNodePointer != null) continue;
            return false;
        } while (!this.currentNodePointer.testNode(this.nodeTest));
        return true;
    }
}

