/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullElementPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class SimplePathInterpreter {
    public static NodePointer interpretPath(EvalContext context, NodePointer parentPointer, Step[] steps) {
        if (parentPointer == null) {
            return null;
        }
        NodePointer pointer = (NodePointer)parentPointer.clone();
        while (pointer != null && !pointer.isNode()) {
            pointer = pointer.getValuePointer();
        }
        int i = 0;
        while (i < steps.length) {
            int count;
            Step step = steps[i];
            int defaultIndex = i == steps.length - 1 ? -1 : 0;
            QName name = ((NodeNameTest)step.getNodeTest()).getNodeName();
            Expression[] predicates = step.getPredicates();
            int n = count = predicates == null ? 0 : predicates.length;
            if (count == 0) {
                pointer = SimplePathInterpreter.singleStep(context, pointer, name, defaultIndex, false);
            } else {
                Expression lastIndexPredicate = null;
                if (!(predicates[count - 1] instanceof NameAttributeTest)) {
                    lastIndexPredicate = predicates[count - 1];
                }
                if (lastIndexPredicate != null) {
                    int index = SimplePathInterpreter.indexFromPredicate(context, lastIndexPredicate);
                    if (count == 1) {
                        pointer = SimplePathInterpreter.singleStep(context, pointer, name, index, false);
                    } else {
                        pointer = SimplePathInterpreter.singleStep(context, pointer, name, -1, false);
                        int j = 0;
                        while (j < count - 1) {
                            String key = SimplePathInterpreter.keyFromPredicate(context, predicates[j]);
                            pointer = j < count - 2 ? SimplePathInterpreter.singleStep(context, pointer, key, -1, true) : SimplePathInterpreter.singleStep(context, pointer, key, index, true);
                            ++j;
                        }
                    }
                } else {
                    pointer = SimplePathInterpreter.singleStep(context, pointer, name, -1, false);
                    int j = 0;
                    while (j < count) {
                        String key = SimplePathInterpreter.keyFromPredicate(context, predicates[j]);
                        pointer = j < count - 1 ? SimplePathInterpreter.singleStep(context, pointer, key, -1, true) : SimplePathInterpreter.singleStep(context, pointer, key, defaultIndex, true);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return pointer;
    }

    public static NodePointer interpretPredicates(EvalContext context, NodePointer pointer, Expression[] predicates) {
        if (predicates == null || predicates.length == 0 || pointer == null) {
            return pointer;
        }
        int count = predicates.length;
        Expression lastIndexPredicate = null;
        if (!(predicates[count - 1] instanceof NameAttributeTest)) {
            lastIndexPredicate = predicates[count - 1];
        }
        if (lastIndexPredicate != null) {
            int index = SimplePathInterpreter.indexFromPredicate(context, lastIndexPredicate);
            if (count == 1) {
                if (index >= 0 && index < pointer.getLength()) {
                    pointer.setIndex(index);
                } else {
                    pointer = new NullElementPointer(pointer, index);
                }
            } else {
                int j = 0;
                while (j < count - 1) {
                    String key = SimplePathInterpreter.keyFromPredicate(context, predicates[j]);
                    pointer = j < count - 2 ? SimplePathInterpreter.singleStep(context, pointer, key, -1, true) : SimplePathInterpreter.singleStep(context, pointer, key, index, true);
                    ++j;
                }
            }
        } else {
            int j = 0;
            while (j < count) {
                String key = SimplePathInterpreter.keyFromPredicate(context, predicates[j]);
                pointer = j < count - 1 ? SimplePathInterpreter.singleStep(context, pointer, key, -1, true) : SimplePathInterpreter.singleStep(context, pointer, key, -1, true);
                ++j;
            }
        }
        return pointer;
    }

    private static NodePointer singleStep(EvalContext context, NodePointer parent, Object property, int index, boolean dynamic) {
        if (parent instanceof PropertyOwnerPointer) {
            PropertyPointer pointer = ((PropertyOwnerPointer)parent).getPropertyPointer();
            String name = property instanceof QName ? ((QName)property).getName() : (String)property;
            pointer.setPropertyName(name);
            if (pointer instanceof NullPropertyPointer && dynamic) {
                ((NullPropertyPointer)pointer).setDynamic(true);
            }
            if (index != -1) {
                if (index >= 0 && index < pointer.getLength()) {
                    pointer.setIndex(index);
                    return pointer.getValuePointer();
                }
                return new NullElementPointer((NodePointer)pointer, index).getValuePointer();
            }
            return pointer.getValuePointer();
        }
        QName name = property instanceof QName ? (QName)property : new QName(null, (String)property);
        NodeIterator it = parent.childIterator(new NodeNameTest(name), false, null);
        if (it != null && it.setPosition(index == -1 ? 1 : index + 1)) {
            return it.getNodePointer();
        }
        NullPropertyPointer pointer = new NullPropertyPointer(parent);
        ((PropertyPointer)pointer).setPropertyName(name.toString());
        pointer.setIndex(index);
        return ((PropertyPointer)pointer).getValuePointer();
    }

    private static int indexFromPredicate(EvalContext context, Expression predicate) {
        Object value = predicate.computeValue(context);
        if (value instanceof EvalContext) {
            value = ((EvalContext)value).getSingleNodePointer();
        }
        if (value instanceof NodePointer) {
            value = ((NodePointer)value).getValue();
        }
        if (value == null) {
            throw new JXPathException("Predicate is null: " + value);
        }
        if (value instanceof Number) {
            return (int)(InfoSetUtil.doubleValue(value) + 0.5) - 1;
        }
        if (InfoSetUtil.booleanValue(value)) {
            return 0;
        }
        return -1;
    }

    private static String keyFromPredicate(EvalContext context, Expression predicate) {
        Expression expr = ((NameAttributeTest)predicate).getNameTestExpression();
        return InfoSetUtil.stringValue(expr.computeValue(context));
    }
}

