/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.container;

import java.util.Locale;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class ContainerPointer
extends NodePointer {
    private Container container;
    private NodePointer valuePointer;

    public ContainerPointer(Container container, Locale locale) {
        super(null, locale);
        this.container = container;
    }

    public ContainerPointer(NodePointer parent, Container container) {
        super(parent);
        this.container = container;
    }

    public boolean isNode() {
        return false;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return this.container.getValue();
    }

    public Object getNodeValue() {
        Object value = this.getBaseValue();
        if (this.index != NodePointer.WHOLE_COLLECTION) {
            return ValueUtils.getValue(value, this.index);
        }
        return value;
    }

    public void setValue(Object value) {
        this.container.setValue(value);
    }

    public NodePointer getValuePointer() {
        if (this.valuePointer == null) {
            Object value = this.getNodeValue();
            this.valuePointer = NodePointer.newChildNodePointer(this, this.getName(), value).getValuePointer();
        }
        return this.valuePointer;
    }

    public int hashCode() {
        return System.identityHashCode(this.container) + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ContainerPointer)) {
            return false;
        }
        ContainerPointer other = (ContainerPointer)object;
        return this.container == other.container && this.index == other.index;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return this.getValuePointer().childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        return this.getValuePointer().attributeIterator(name);
    }

    public NodeIterator namespaceIterator() {
        return this.getValuePointer().namespaceIterator();
    }

    public NodePointer namespacePointer(String namespace) {
        return this.getValuePointer().namespacePointer(namespace);
    }

    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return pointer1.getIndex() - pointer2.getIndex();
    }
}

