/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.taskdefs.XSLTLoggerAware;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TraXLiaison
implements XSLTLiaison,
ErrorListener,
XSLTLoggerAware {
    private TransformerFactory tfactory = null;
    private File stylesheet;
    private Templates templates = null;
    private long templatesModTime;
    private Transformer transformer = null;
    private XSLTLogger logger;
    private EntityResolver entityResolver;
    private URIResolver uriResolver;
    private Vector outputProperties = new Vector();
    private Vector params = new Vector();

    public void setOutputProperty(String name, String value) {
        String[] pair = new String[]{name, value};
        this.outputProperties.addElement(pair);
    }

    public void setStylesheet(File stylesheet) throws Exception {
        if (this.stylesheet != null) {
            this.transformer = null;
            if (!this.stylesheet.equals(stylesheet) || stylesheet.lastModified() != this.templatesModTime) {
                this.templates = null;
            }
        }
        this.stylesheet = stylesheet;
    }

    public void transform(File infile, File outfile) throws Exception {
        if (this.transformer == null) {
            this.createTransformer();
        }
        BufferedInputStream fis = null;
        OutputStream fos = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(infile));
            fos = new BufferedOutputStream(new FileOutputStream(outfile));
            StreamResult res = new StreamResult(fos);
            res.setSystemId(JAXPUtils.getSystemId((File)outfile));
            Source src = this.getSource(fis, infile);
            this.transformer.transform(src, res);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fis != null) {
                ((InputStream)fis).close();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException ignored) {}
    }

    public void addParam(String name, String value) {
        String[] pair = new String[]{name, value};
        this.params.addElement(pair);
    }

    public void setLogger(XSLTLogger l) {
        this.logger = l;
    }

    public void error(TransformerException e) {
        this.logError(e, "Error");
    }

    public void fatalError(TransformerException e) {
        this.logError(e, "Fatal Error");
        throw new BuildException("Fatal error during transformation", (Throwable)e);
    }

    public void warning(TransformerException e) {
        this.logError(e, "Warning");
    }

    private void logError(TransformerException e, String type) {
        if (this.logger == null) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        SourceLocator locator = e.getLocator();
        if (locator != null) {
            String systemid = locator.getSystemId();
            if (systemid != null) {
                String url = systemid;
                if (url.startsWith("file:///")) {
                    url = url.substring(8);
                }
                msg.append(url);
            } else {
                msg.append("Unknown file");
            }
            int line = locator.getLineNumber();
            if (line != -1) {
                msg.append(":" + line);
                int column = locator.getColumnNumber();
                if (column != -1) {
                    msg.append(":" + column);
                }
            }
        }
        msg.append(": " + type + "! ");
        msg.append(e.getMessage());
        if (e.getCause() != null) {
            msg.append(" Cause: " + e.getCause());
        }
        this.logger.log(msg.toString());
    }

    public void setEntityResolver(EntityResolver aResolver) {
        this.entityResolver = aResolver;
    }

    public void setURIResolver(URIResolver aResolver) {
        this.uriResolver = aResolver;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Source getSource(InputStream is, File infile) throws Exception {
        void var3_6;
        Object var3_3 = null;
        if (this.entityResolver != null) {
            if (!this.getFactory().getFeature("http://javax.xml.transform.sax.SAXSource/feature")) throw new IllegalStateException("xcatalog specified, but parser doesn't support SAX");
            SAXParserFactory spFactory = SAXParserFactory.newInstance();
            spFactory.setNamespaceAware(true);
            XMLReader reader = spFactory.newSAXParser().getXMLReader();
            reader.setEntityResolver(this.entityResolver);
            SAXSource sAXSource = new SAXSource(reader, new InputSource(is));
        } else {
            StreamSource streamSource = new StreamSource(is);
        }
        var3_6.setSystemId(JAXPUtils.getSystemId((File)infile));
        return var3_6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readTemplates() throws IOException, TransformerConfigurationException {
        BufferedInputStream xslStream = null;
        try {
            xslStream = new BufferedInputStream(new FileInputStream(this.stylesheet));
            this.templatesModTime = this.stylesheet.lastModified();
            StreamSource src = new StreamSource(xslStream);
            src.setSystemId(JAXPUtils.getSystemId((File)this.stylesheet));
            this.templates = this.getFactory().newTemplates(src);
            Object var4_3 = null;
            if (xslStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (xslStream == null) throw throwable;
            ((InputStream)xslStream).close();
            throw throwable;
        }
        ((InputStream)xslStream).close();
    }

    private void createTransformer() throws Exception {
        if (this.templates == null) {
            this.readTemplates();
        }
        this.transformer = this.templates.newTransformer();
        this.transformer.setErrorListener(this);
        if (this.uriResolver != null) {
            this.transformer.setURIResolver(this.uriResolver);
        }
        int i = 0;
        while (i < this.params.size()) {
            String[] pair = (String[])this.params.elementAt(i);
            this.transformer.setParameter(pair[0], pair[1]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.outputProperties.size()) {
            String[] pair = (String[])this.outputProperties.elementAt(i2);
            this.transformer.setOutputProperty(pair[0], pair[1]);
            ++i2;
        }
    }

    private TransformerFactory getFactory() throws BuildException {
        if (this.tfactory != null) {
            return this.tfactory;
        }
        this.tfactory = TransformerFactory.newInstance();
        this.tfactory.setErrorListener(this);
        if (this.uriResolver != null) {
            this.tfactory.setURIResolver(this.uriResolver);
        }
        return this.tfactory;
    }

    protected String getSystemId(File file) {
        return JAXPUtils.getSystemId((File)file);
    }
}

