/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.SerializationHelper;
import org.apache.excalibur.altrmi.server.impl.ServerStreamReadWriter;

public class ServerCustomStreamReadWriter
extends ServerStreamReadWriter {
    private DataInputStream mDataInputStream;
    private DataOutputStream mDataOutputStream;

    protected void initialize() throws IOException {
        this.mDataInputStream = new DataInputStream(this.mInputStream);
        this.mDataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mOutputStream));
    }

    protected synchronized AltrmiRequest writeReplyAndGetRequest(AltrmiReply altrmiReply) throws IOException, ClassNotFoundException {
        if (altrmiReply != null) {
            this.writeReply(altrmiReply);
        }
        return this.readRequest();
    }

    private void writeReply(AltrmiReply altrmiReply) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiReply);
        this.mDataOutputStream.writeInt(aBytes.length);
        this.mDataOutputStream.write(aBytes);
        this.mDataOutputStream.flush();
    }

    private AltrmiRequest readRequest() throws IOException, ClassNotFoundException {
        int byteArraySize = this.mDataInputStream.readInt();
        byte[] byteArray = new byte[byteArraySize];
        int pos = 0;
        int cnt = 0;
        while (pos < byteArraySize) {
            int read = this.mDataInputStream.read(byteArray, pos, byteArraySize - pos);
            pos += read;
            ++cnt;
        }
        return (AltrmiRequest)SerializationHelper.getInstanceFromBytes((byte[])byteArray);
    }
}

