/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.apf;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiSingleImageRasterDecoder;
import com.sun.jimi.core.decoder.apf.APFDecoderFactory;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class APFDecoder
extends JimiSingleImageRasterDecoder {
    protected int width;
    protected int height;
    protected DataInputStream dataInput;
    protected IntRasterImage jimiImage;

    protected void createJimiImage() throws JimiException {
        this.jimiImage = this.getJimiImageFactory().createIntRasterImage(this.width, this.height, ColorModel.getRGBdefault());
    }

    public void doImageDecode() throws JimiException, IOException {
        this.readData();
        this.jimiImage.setFinished();
    }

    public MutableJimiRasterImage doInitDecoding(JimiImageFactory jimiImageFactory, InputStream inputStream) throws JimiException, IOException {
        this.readHeader();
        this.createJimiImage();
        return this.jimiImage;
    }

    protected void readData() throws IOException, ImageAccessException {
        int[] nArray = new int[this.width];
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                nArray[n2] = this.dataInput.readInt();
                ++n2;
            }
            this.jimiImage.setRow(n, nArray, 0);
            this.setProgress((n + 1) * 1000 / this.height);
            ++n;
        }
    }

    protected void readHeader() throws JimiException, IOException {
        byte[] byArray = APFDecoderFactory.FORMAT_SIGNATURES[0];
        byte[] byArray2 = new byte[byArray.length];
        this.getInput().read(byArray2);
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                throw new JimiException("Invalid format signature.");
            }
            ++n;
        }
        this.dataInput = new DataInputStream(this.getInput());
        this.width = this.dataInput.readInt();
        this.height = this.dataInput.readInt();
    }
}

