/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    protected File zipFile;
    private ZipScanner zs;
    private File baseDir;
    protected Hashtable entries = new Hashtable();
    private Vector groupfilesets = new Vector();
    private Vector filesetsFromGroupfilesets = new Vector();
    protected String duplicate = "add";
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    protected Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    private static FileUtils fileUtils = FileUtils.newFileUtils();
    private boolean addingNewFiles = false;
    private String encoding;

    public void setZipfile(File zipFile) {
        this.setDestFile(zipFile);
    }

    public void setFile(File file) {
        this.setDestFile(file);
    }

    public void setDestFile(File destFile) {
        this.zipFile = destFile;
    }

    public File getDestFile() {
        return this.zipFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(boolean c) {
        this.doCompress = c;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public void setUpdate(boolean c) {
        this.doUpdate = c;
        this.savedDoUpdate = c;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void addZipfileset(ZipFileSet set) {
        this.filesets.addElement(set);
    }

    public void addZipGroupFileset(FileSet set) {
        this.groupfilesets.addElement(set);
    }

    public void setDuplicate(Duplicate df) {
        this.duplicate = df.getValue();
    }

    public void setWhenempty(WhenEmpty we) {
        this.emptyBehavior = we.getValue();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && this.groupfilesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        File renamedFile = null;
        this.addingNewFiles = true;
        this.doUpdate = this.doUpdate && this.zipFile.exists();
        int i = 0;
        while (i < this.groupfilesets.size()) {
            this.log("Processing groupfileset ", 3);
            FileSet fs = (FileSet)this.groupfilesets.elementAt(i);
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            File basedir = scanner.getBasedir();
            int j = 0;
            while (j < files.length) {
                this.log("Adding file " + files[j] + " to fileset", 3);
                ZipFileSet zf = new ZipFileSet();
                zf.setSrc(new File(basedir, files[j]));
                this.filesets.addElement(zf);
                this.filesetsFromGroupfilesets.addElement(zf);
                ++j;
            }
            ++i;
        }
        Vector<FileSet> vfss = new Vector<FileSet>();
        if (this.baseDir != null) {
            FileSet fs = (FileSet)this.getImplicitFileSet().clone();
            fs.setDir(this.baseDir);
            vfss.addElement(fs);
        }
        int i2 = 0;
        while (i2 < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i2);
            vfss.addElement(fs);
            ++i2;
        }
        Object[] fss = new FileSet[vfss.size()];
        vfss.copyInto(fss);
        boolean success = false;
        try {
            try {
                Resource[][] addThem = this.getResourcesToAdd((FileSet[])fss, this.zipFile, false);
                if (Zip.isEmpty(addThem)) {
                    Object var21_14 = null;
                    this.cleanUp();
                    return;
                }
                if (this.doUpdate) {
                    renamedFile = fileUtils.createTempFile("zip", ".tmp", fileUtils.getParentFile(this.zipFile));
                    try {
                        if (!this.zipFile.renameTo(renamedFile)) {
                            throw new BuildException("Unable to rename old file to temporary file");
                        }
                    }
                    catch (SecurityException e) {
                        throw new BuildException("Not allowed to rename old file to temporary file");
                    }
                }
                String action = this.doUpdate ? "Updating " : "Building ";
                this.log(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
                ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(this.zipFile));
                zOut.setEncoding(this.encoding);
                try {
                    if (this.doCompress) {
                        zOut.setMethod(8);
                    } else {
                        zOut.setMethod(0);
                    }
                    this.initZipOutputStream(zOut);
                    int i3 = 0;
                    while (i3 < fss.length) {
                        if (addThem[i3].length != 0) {
                            this.addResources((FileSet)fss[i3], addThem[i3], zOut);
                        }
                        ++i3;
                    }
                    if (this.doUpdate) {
                        this.addingNewFiles = false;
                        ZipFileSet oldFiles = new ZipFileSet();
                        oldFiles.setSrc(renamedFile);
                        int i4 = 0;
                        while (i4 < this.addedFiles.size()) {
                            PatternSet.NameEntry ne = oldFiles.createExclude();
                            ne.setName((String)this.addedFiles.elementAt(i4));
                            ++i4;
                        }
                        DirectoryScanner ds = oldFiles.getDirectoryScanner(this.getProject());
                        String[] f = ds.getIncludedFiles();
                        Resource[] r = new Resource[f.length];
                        int i5 = 0;
                        while (i5 < f.length) {
                            r[i5] = ds.getResource(f[i5]);
                            ++i5;
                        }
                        this.addResources(oldFiles, r, zOut);
                    }
                    this.finalizeZipOutputStream(zOut);
                    if (this.doUpdate && !renamedFile.delete()) {
                        this.log("Warning: unable to delete temporary file " + renamedFile.getName(), 1);
                    }
                    success = true;
                    Object var18_25 = null;
                }
                catch (Throwable throwable) {
                    block34: {
                        Object var18_26 = null;
                        try {
                            if (zOut != null) {
                                zOut.close();
                            }
                        }
                        catch (IOException ex) {
                            if (!success) break block34;
                            throw ex;
                        }
                    }
                    throw throwable;
                }
                try {
                    if (zOut != null) {
                        zOut.close();
                    }
                }
                catch (IOException ex) {
                    if (success) {
                        throw ex;
                    }
                }
            }
            catch (IOException ioe) {
                String msg = "Problem creating " + this.archiveType + ": " + ioe.getMessage();
                if (!(this.doUpdate && renamedFile == null || this.zipFile.delete())) {
                    msg = msg + " (and the archive is probably corrupt but I could not delete it)";
                }
                if (this.doUpdate && renamedFile != null && !renamedFile.renameTo(this.zipFile)) {
                    msg = msg + " (and I couldn't rename the temporary file " + renamedFile.getName() + " back)";
                }
                throw new BuildException(msg, ioe, this.getLocation());
            }
        }
        catch (Throwable throwable) {
            Object var21_16 = null;
            this.cleanUp();
            throw throwable;
        }
        Object var21_15 = null;
        this.cleanUp();
    }

    protected final boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void addResources(FileSet fileset, Resource[] resources, ZipOutputStream zOut) throws IOException {
        String prefix = "";
        String fullpath = "";
        int dirMode = 16877;
        int fileMode = 33188;
        ZipFileSet zfs = null;
        if (fileset instanceof ZipFileSet) {
            zfs = (ZipFileSet)fileset;
            prefix = zfs.getPrefix();
            fullpath = zfs.getFullpath();
            dirMode = zfs.getDirMode();
            fileMode = zfs.getDirMode();
        }
        if (prefix.length() > 0 && fullpath.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes must not be set on the same fileset.");
        }
        if (resources.length != 1 && fullpath.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        if (prefix.length() > 0 && !prefix.endsWith("/") && !prefix.endsWith("\\")) {
            prefix = prefix + "/";
        }
        ZipFile zf = null;
        try {
            boolean dealingWithFiles = false;
            File base = null;
            if (zfs == null || zfs.getSrc() == null) {
                dealingWithFiles = true;
                base = fileset.getDir(this.getProject());
            } else {
                zf = new ZipFile(zfs.getSrc());
            }
            int i = 0;
            while (i < resources.length) {
                String name = null;
                name = fullpath.length() > 0 ? fullpath : resources[i].getName();
                if (!"".equals(name = name.replace(File.separatorChar, '/'))) {
                    java.util.zip.ZipEntry ze;
                    if (resources[i].isDirectory() && !name.endsWith("/")) {
                        name = name + "/";
                    }
                    this.addParentDirs(base, name, zOut, prefix, dirMode);
                    if (!resources[i].isDirectory() && dealingWithFiles) {
                        File f = fileUtils.resolveFile(base, resources[i].getName());
                        this.zipFile(f, zOut, prefix + name, fileMode);
                    } else if (!resources[i].isDirectory() && (ze = zf.getEntry(resources[i].getName())) != null) {
                        this.zipFile(zf.getInputStream(ze), zOut, prefix + name, ze.getTime(), zfs.getSrc(), fileMode);
                    }
                }
                ++i;
            }
            Object var16_15 = null;
            if (zf == null) return;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (zf == null) throw throwable;
            zf.close();
            throw throwable;
        }
        zf.close();
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean createEmptyZip(File zipFile) throws BuildException {
        this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(zipFile);
                byte[] empty = new byte[22];
                empty[0] = 80;
                empty[1] = 75;
                empty[2] = 5;
                empty[3] = 6;
                ((OutputStream)os).write(empty);
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe, this.getLocation());
            }
            Object var5_5 = null;
            if (os == null) return true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (os == null) throw throwable;
            try {
                ((OutputStream)os).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ((OutputStream)os).close();
        return true;
    }

    private synchronized ZipScanner getZipScanner() {
        if (this.zs == null) {
            this.zs = new ZipScanner();
            this.zs.setSrc(this.zipFile);
        }
        return this.zs;
    }

    protected Resource[][] getResourcesToAdd(FileSet[] filesets, File zipFile, boolean needsUpdate) throws BuildException {
        Resource[][] initialResources = this.grabResources(filesets);
        if (Zip.isEmpty(initialResources)) {
            if (this.emptyBehavior.equals("skip")) {
                if (this.doUpdate) {
                    this.log(this.archiveType + " archive " + zipFile + " not updated because no new files were included.", 3);
                } else {
                    this.log("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
                }
            } else {
                if (this.emptyBehavior.equals("fail")) {
                    throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.getLocation());
                }
                this.createEmptyZip(zipFile);
            }
            return initialResources;
        }
        if (!zipFile.exists()) {
            return initialResources;
        }
        if (needsUpdate && !this.doUpdate) {
            return initialResources;
        }
        Resource[][] newerResources = new Resource[filesets.length][];
        int i = 0;
        while (i < filesets.length) {
            if (!(this.fileset instanceof ZipFileSet) || ((ZipFileSet)this.fileset).getSrc() == null) {
                File base = filesets[i].getDir(this.getProject());
                int j = 0;
                while (j < initialResources[i].length) {
                    File resourceAsFile = fileUtils.resolveFile(base, initialResources[i][j].getName());
                    if (resourceAsFile.equals(zipFile)) {
                        throw new BuildException("A zip file cannot include itself", this.getLocation());
                    }
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < filesets.length) {
            if (initialResources[i2].length == 0) {
                newerResources[i2] = new Resource[0];
            } else {
                FileNameMapper myMapper = new IdentityMapper();
                if (filesets[i2] instanceof ZipFileSet) {
                    ZipFileSet zfs = (ZipFileSet)filesets[i2];
                    if (zfs.getFullpath() != null && !zfs.getFullpath().equals("")) {
                        MergingMapper fm = new MergingMapper();
                        fm.setTo(zfs.getFullpath());
                        myMapper = fm;
                    } else if (zfs.getPrefix() != null && !zfs.getPrefix().equals("")) {
                        GlobPatternMapper gm = new GlobPatternMapper();
                        gm.setFrom("*");
                        String prefix = zfs.getPrefix();
                        if (!prefix.endsWith("/") && !prefix.endsWith("\\")) {
                            prefix = prefix + "/";
                        }
                        gm.setTo(prefix + "*");
                        myMapper = gm;
                    }
                }
                newerResources[i2] = ResourceUtils.selectOutOfDateSources(this, initialResources[i2], myMapper, this.getZipScanner());
                boolean bl = needsUpdate = needsUpdate || newerResources[i2].length > 0;
                if (needsUpdate && !this.doUpdate) break;
            }
            ++i2;
        }
        if (needsUpdate && !this.doUpdate) {
            return initialResources;
        }
        return newerResources;
    }

    protected Resource[][] grabResources(FileSet[] filesets) {
        Resource[][] result = new Resource[filesets.length][];
        int i = 0;
        while (i < filesets.length) {
            DirectoryScanner rs = filesets[i].getDirectoryScanner(this.getProject());
            Vector<Resource> resources = new Vector<Resource>();
            String[] directories = rs.getIncludedDirectories();
            int j = 0;
            while (j < directories.length) {
                resources.add(rs.getResource(directories[j]));
                ++j;
            }
            String[] files = rs.getIncludedFiles();
            int j2 = 0;
            while (j2 < files.length) {
                resources.add(rs.getResource(files[j2]));
                ++j2;
            }
            result[i] = new Resource[resources.size()];
            resources.copyInto(result[i]);
            ++i;
        }
        return result;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.log("adding directory " + vPath, 3);
        this.addedDirs.put(vPath, vPath);
        ZipEntry ze = new ZipEntry(vPath);
        if (dir != null && dir.exists()) {
            ze.setTime(dir.lastModified() + 1999L);
        } else {
            ze.setTime(System.currentTimeMillis() + 1999L);
        }
        ze.setSize(0L);
        ze.setMethod(0);
        ze.setCrc(EMPTY_CRC);
        ze.setUnixMode(mode);
        zOut.putNextEntry(ze);
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (this.entries.contains(vPath)) {
            if (this.duplicate.equals("preserve")) {
                this.log(vPath + " already added, skipping", 2);
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new BuildException("Duplicate file " + vPath + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.log("duplicate file " + vPath + " found, adding.", 3);
        } else {
            this.log("adding entry " + vPath, 3);
        }
        this.entries.put(vPath, vPath);
        ZipEntry ze = new ZipEntry(vPath);
        ze.setTime(lastModified);
        if (!this.doCompress) {
            long size = 0L;
            CRC32 cal = new CRC32();
            if (!in.markSupported()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                    bos.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in = new ByteArrayInputStream(bos.toByteArray());
            } else {
                in.mark(Integer.MAX_VALUE);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in.reset();
            }
            ze.setSize(size);
            ze.setCrc(cal.getValue());
        }
        ze.setUnixMode(mode);
        zOut.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            if (count == 0) continue;
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        this.addedFiles.addElement(vPath);
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.getLocation());
        }
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified() + 1999L, null, mode);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fIn.close();
            throw throwable;
        }
        fIn.close();
    }

    protected final void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix, int dirMode) throws IOException {
        if (!this.doFilesonly) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length();
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.get(prefix + dir) != null) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f = null;
                f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                this.zipDir(f, zOut, prefix + dir, dirMode);
            }
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        Enumeration enumeration = this.filesetsFromGroupfilesets.elements();
        while (enumeration.hasMoreElements()) {
            ZipFileSet zf = (ZipFileSet)enumeration.nextElement();
            this.filesets.removeElement(zf);
        }
        this.filesetsFromGroupfilesets.removeAllElements();
    }

    public void reset() {
        this.filesets.removeAllElements();
        this.zipFile = null;
        this.baseDir = null;
        this.groupfilesets.removeAllElements();
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.emptyBehavior = "skip";
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected static final boolean isEmpty(Resource[][] r) {
        int i = 0;
        while (i < r.length) {
            if (r[i].length > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "preserve", "fail"};
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

