/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.cocoon.acting.ConfigurableComposerAction;
import org.apache.cocoon.acting.ConfigurationHelper;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.xml.sax.ContentHandler;

public abstract class AbstractComplementaryConfigurableAction
extends ConfigurableComposerAction {
    private static Map configurations = new HashMap();

    protected Configuration getConfiguration(String descriptor) throws ConfigurationException {
        boolean reloadable = true;
        if (this.settings.containsKey("reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get("reloadable"));
        }
        return this.getConfiguration(descriptor, null, reloadable);
    }

    protected Configuration getConfiguration(String descriptor, boolean reloadable) throws ConfigurationException {
        return this.getConfiguration(descriptor, null, reloadable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Configuration getConfiguration(String descriptor, SourceResolver resolver, boolean reloadable) throws ConfigurationException {
        ConfigurationHelper conf = null;
        if (descriptor == null) {
            throw new ConfigurationException("The form descriptor is not set!");
        }
        Map map = configurations;
        synchronized (map) {
            Source resource = null;
            try {
                try {
                    resource = resolver.resolve(descriptor);
                    conf = (ConfigurationHelper)configurations.get(resource.getSystemId());
                    if (conf == null || reloadable && conf.lastModified != resource.getLastModified()) {
                        this.getLogger().debug("(Re)Loading " + descriptor);
                        if (conf == null) {
                            conf = new ConfigurationHelper();
                        }
                        SAXConfigurationHandler builder = new SAXConfigurationHandler();
                        resource.toSAX((ContentHandler)builder);
                        conf.lastModified = resource.getLastModified();
                        conf.configuration = builder.getConfiguration();
                        configurations.put(resource.getSystemId(), conf);
                    } else {
                        this.getLogger().debug("Using cached configuration for " + descriptor);
                    }
                }
                catch (Exception e) {
                    String string;
                    this.getLogger().error("Could not configure Database mapping environment", (Throwable)e);
                    StringBuffer stringBuffer = new StringBuffer().append("Error trying to load configurations for resource: ");
                    if (resource == null) {
                        string = "null";
                        throw new ConfigurationException(stringBuffer.append(string).toString());
                    }
                    string = resource.getSystemId();
                    throw new ConfigurationException(stringBuffer.append(string).toString());
                }
                Object var9_9 = null;
                if (resource == null) return conf.configuration;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (resource == null) throw throwable;
                resource.recycle();
                throw throwable;
            }
            resource.recycle();
            return conf.configuration;
        }
    }
}

