/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.search;

import java.io.File;
import java.io.IOException;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.search.LuceneCocoonSearcher;
import org.apache.cocoon.util.ClassUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class SimpleLuceneCocoonSearcherImpl
extends AbstractLoggable
implements LuceneCocoonSearcher,
Configurable,
Composable,
Disposable,
Recyclable {
    protected static final String ANALYZER_CLASSNAME_CONFIG = "analyzer-classname";
    protected static final String ANALYZER_CLASSNAME_DEFAULT = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    protected static final String DEFAULT_SEARCH_FIELD_CONFIG = "default-search-field";
    protected static final String DEFAULT_SEARCH_FIELD_DEFAULT = "body";
    protected static final String DEFAULT_QUERY_CONFIG = "default-query";
    protected static final String DEFAULT_QUERY_DEFAULT = null;
    protected static final String QUERYPARSER_CLASSNAME_CONFIG = "queryparser-classname";
    protected static final String QUERYPARSER_CLASSNAME_DEFAULT = "org.apache.lucene.queryParser.QueryParser";
    protected static final String DIRECTORY_CONFIG = "directory";
    protected static final String DIRECTORY_DEFAULT = null;
    protected ComponentManager manager = null;
    private String analyzerClassnameDefault = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private String defaultSearchFieldDefault = "body";
    private String defaultQueryDefault = DEFAULT_QUERY_DEFAULT;
    private String queryparserClassnameDefault = "org.apache.lucene.queryParser.QueryParser";
    private String directoryDefault = DIRECTORY_DEFAULT;
    private Analyzer analyzer;
    private Directory directory;
    private IndexSearcher indexSearcher;
    private IndexReaderCache indexReaderCache;

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
        if (this.indexReaderCache != null) {
            this.indexReaderCache.close();
            this.indexReaderCache = null;
        }
    }

    public IndexReader getReader() throws IOException {
        if (this.indexReaderCache == null) {
            this.indexReaderCache = new IndexReaderCache();
        }
        return this.indexReaderCache.getIndexReader(this.directory);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        String value;
        Configuration child = conf.getChild(ANALYZER_CLASSNAME_CONFIG, false);
        if (child != null && (value = conf.getValue(ANALYZER_CLASSNAME_DEFAULT)) != null) {
            this.analyzerClassnameDefault = value;
            try {
                this.analyzer = (Analyzer)ClassUtils.newInstance(this.analyzerClassnameDefault);
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot create analyzer of class " + this.analyzerClassnameDefault, (Throwable)e);
            }
        }
        if ((child = conf.getChild(DEFAULT_SEARCH_FIELD_CONFIG, false)) != null && (value = conf.getValue(DEFAULT_SEARCH_FIELD_DEFAULT)) != null) {
            this.defaultSearchFieldDefault = value;
        }
        if ((child = conf.getChild(DEFAULT_QUERY_CONFIG, false)) != null && (value = conf.getValue(DEFAULT_QUERY_DEFAULT)) != null) {
            this.defaultQueryDefault = value;
        }
        if ((child = conf.getChild(QUERYPARSER_CLASSNAME_CONFIG, false)) != null && (value = conf.getValue(QUERYPARSER_CLASSNAME_DEFAULT)) != null) {
            this.queryparserClassnameDefault = value;
        }
        if ((child = conf.getChild(DIRECTORY_CONFIG, false)) != null && (value = conf.getValue(DIRECTORY_DEFAULT)) != null) {
            this.directoryDefault = value;
            try {
                this.setDirectory((Directory)FSDirectory.getDirectory((File)new File(this.directoryDefault), (boolean)false));
            }
            catch (IOException ioe) {
                throw new ConfigurationException("Cannot set index directory " + this.directoryDefault, (Throwable)ioe);
            }
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        this.releaseIndexSearcher();
        this.releaseIndexReaderCache();
    }

    public void recycle() {
        this.releaseIndexSearcher();
        this.releaseIndexReaderCache();
    }

    public Hits search(String query_string, String default_field) throws ProcessingException {
        Hits hits = null;
        if (query_string == null) {
            query_string = this.defaultQueryDefault;
        }
        if (default_field == null) {
            default_field = this.defaultSearchFieldDefault;
        }
        try {
            Query query = QueryParser.parse((String)query_string, (String)default_field, (Analyzer)this.analyzer);
            this.releaseIndexSearcher();
            IndexSearcher indexSearcher = new IndexSearcher(this.getReader());
            hits = indexSearcher.search(query);
        }
        catch (ParseException pe) {
            throw new ProcessingException("Cannot parse query " + query_string, pe);
        }
        catch (IOException ioe) {
            throw new ProcessingException("Cannot access hits", ioe);
        }
        return hits;
    }

    private void releaseIndexSearcher() {
        if (this.indexSearcher != null) {
            try {
                this.indexSearcher.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.indexSearcher = null;
        }
    }

    private void releaseIndexReaderCache() {
        if (this.indexReaderCache != null) {
            this.indexReaderCache = null;
        }
    }

    static class IndexReaderCache {
        private IndexReader indexReader;
        private long lastModified;

        IndexReaderCache() {
        }

        public IndexReader getIndexReader(Directory directory) throws IOException {
            if (this.indexReader == null) {
                this.createIndexReader(directory);
            } else if (!this.indexReaderIsValid(directory)) {
                this.createIndexReader(directory);
            }
            return this.indexReader;
        }

        public void close() {
            if (this.indexReader != null) {
                try {
                    this.indexReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.indexReader = null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean indexReaderIsValid(Directory directory) throws IOException {
            if (this.indexReader == null) return false;
            if (IndexReader.lastModified((Directory)directory) != this.lastModified) return false;
            return true;
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        private void createIndexReader(Directory directory) throws IOException {
            this.close();
            this.indexReader = IndexReader.open((Directory)directory);
            this.lastModified = IndexReader.lastModified((Directory)directory);
        }
    }
}

