/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.ResultBase;
import com.jclark.xsl.sax.XMLProcessorEx;
import com.jclark.xsl.sax.XMLProcessorImpl;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.ExtensionHandler;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.ParameterSet;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.Sheet;
import com.jclark.xsl.tr.XMLProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.cocoon.Modifiable;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.log.Logger;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XTProcessor
implements Cloneable,
ParameterSet,
Modifiable,
Loggable,
Composable {
    protected Logger log;
    private XMLProcessorEx sheetLoader;
    private Parser sheetParser;
    private Sheet sheet;
    private Engine engine;
    private InputSource sheetSource;
    private ResultBase result;
    private DocumentHandler documentHandler;
    private ErrorHandler errorHandler;
    private HashMap params = new HashMap();
    private File xslFile;
    private long lastModified;
    private ComponentManager manager;

    XTProcessor() {
    }

    public void setLogger(Logger logger) {
        if (this.log == null) {
            this.log = logger;
        }
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void setParser(Parser sheetParser) {
        this.sheetParser = sheetParser;
        this.sheetLoader = new XMLProcessorImpl(sheetParser);
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (this.sheetParser != null) {
            this.sheetParser.setErrorHandler(handler);
        }
        if (this.sheetLoader != null) {
            this.sheetLoader.setErrorHandler(handler);
        }
        this.errorHandler = handler;
    }

    public void loadStylesheet(InputSource sheetSource) throws SAXException, IOException {
        URL url = null;
        URLFactory urlFactory = null;
        try {
            try {
                urlFactory = (URLFactory)this.manager.lookup("org.apache.cocoon.components.url.URLFactory");
                url = urlFactory.getURL(sheetSource.getSystemId());
            }
            catch (Exception e) {
                this.log.error("cannot obtain the URLFactory", (Throwable)e);
                throw new SAXException("cannot obtain the URLFactory", e);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.manager.release((Component)urlFactory);
            throw throwable;
        }
        this.manager.release((Component)urlFactory);
        this.xslFile = new File(url.getFile());
        this.lastModified = this.xslFile.lastModified();
        this.engine = new EngineImpl((XMLProcessor)this.sheetLoader, (ExtensionHandler)new ExtensionHandlerImpl());
        try {
            Node node = this.sheetLoader.load(sheetSource, 0, this.engine.getSheetLoadContext(), this.engine.getNameTable());
            this.sheet = this.engine.createSheet(node);
        }
        catch (XSLException e) {
            this.handleXSLException(e);
        }
    }

    public XMLProcessorImpl.Builder createBuilder(String systemId) {
        XMLProcessorImpl.Builder builder = XMLProcessorImpl.createBuilder((String)systemId, (int)0, (LoadContext)this.sheet.getSourceLoadContext(), (NameTable)this.engine.getNameTable());
        return builder;
    }

    public void process(Node root) throws SAXException, IOException {
        try {
            this.result = new MultiNamespaceResult(this.documentHandler, this.errorHandler);
            this.sheet.process(root, (XMLProcessor)this.sheetLoader, (ParameterSet)this, (Result)this.result);
        }
        catch (XSLException e) {
            this.handleXSLException(e);
        }
    }

    void handleXSLException(XSLException e) throws SAXException, IOException {
        this.log.error("XTTransformer", (Throwable)e);
        String systemId = null;
        int lineNumber = -1;
        Node node = e.getNode();
        if (node != null) {
            URL url = node.getURL();
            if (url != null) {
                systemId = url.toString();
            }
            lineNumber = node.getLineNumber();
        }
        Exception wrapped = e.getException();
        String message = e.getMessage();
        if (systemId != null || lineNumber != -1) {
            throw new SAXParseException(message, null, systemId, lineNumber, -1, wrapped);
        }
        if (message == null) {
            if (wrapped instanceof SAXException) {
                throw (SAXException)wrapped;
            }
            if (wrapped instanceof IOException) {
                throw (IOException)wrapped;
            }
        }
        throw new SAXException(message, wrapped);
    }

    public Object clone() {
        try {
            XTProcessor cloned = (XTProcessor)super.clone();
            cloned.setLogger(this.log);
            cloned.params = (HashMap)cloned.params.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            this.log.error("unexpected CloneNotSupportedException", (Throwable)e);
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    public Object getParameter(Name name) {
        String nameString = name.getNamespace();
        nameString = nameString == null ? name.getLocalPart() : nameString + '^' + name.getLocalPart();
        return this.params.get(nameString);
    }

    public void setParameter(String name, Object obj) {
        this.params.put(name, obj);
    }

    public boolean modifiedSince(long date) {
        return date < this.xslFile.lastModified();
    }

    public boolean hasChanged() {
        if (this.xslFile == null) {
            return false;
        }
        return this.modifiedSince(this.lastModified);
    }
}

