/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.style.XSLWithParam;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLCallTemplate
extends StyleElement {
    private int calledTemplateFingerprint = -1;
    private XSLTemplate template = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private String calledTemplateName = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean doesPostProcessing() {
        return false;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            int n3 = n & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string2 = attributeCollection.getValue(n2);
            } else if (n3 == standardNames.SAXON_ALLOW_AVT) {
                string = attributeCollection.getValue(n2);
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string2 == null) {
            this.reportAbsence("name");
            return;
        }
        int n4 = n = string != null && string.equals("yes") ? 1 : 0;
        if (n != 0) {
            this.calledTemplateExpression = this.makeAttributeValueTemplate(string2);
        } else {
            if (!Name.isQName(string2)) {
                this.compileError("Name of called template must be a valid QName");
            }
            this.calledTemplateName = string2;
            try {
                this.calledTemplateFingerprint = this.makeNameCode(string2, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.calledTemplateExpression == null) {
            this.template = this.findTemplate(this.calledTemplateFingerprint);
            if (Navigator.isAncestor(this.template, this)) {
                this.useTailRecursion = true;
                StyleElement styleElement = this;
                while (styleElement != this.template) {
                    if (((StyleElement)styleElement).isInstruction() && styleElement.getNextSibling() != null || ((StyleElement)styleElement).doesPostProcessing()) {
                        this.useTailRecursion = false;
                        break;
                    }
                    styleElement = (StyleElement)styleElement.getParentNode();
                }
            }
        }
    }

    private XSLTemplate findTemplate(int n) throws TransformerConfigurationException {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Vector vector = xSLStyleSheet.getTopLevel();
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            XSLTemplate xSLTemplate;
            if (vector.elementAt(n2) instanceof XSLTemplate && (xSLTemplate = (XSLTemplate)vector.elementAt(n2)).getTemplateFingerprint() == n) {
                return xSLTemplate;
            }
            --n2;
        }
        this.compileError("No template exists named " + this.calledTemplateName);
        return null;
    }

    public void process(Context context) throws TransformerException {
        Object object;
        XSLTemplate xSLTemplate = this.template;
        if (this.calledTemplateExpression != null) {
            int n;
            object = this.calledTemplateExpression.evaluateAsString(context);
            if (!Name.isQName((String)object)) {
                throw this.styleError("Invalid template name: " + (String)object);
            }
            try {
                n = this.makeNameCode((String)object, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                throw this.styleError(namespaceException.getMessage());
            }
            xSLTemplate = this.findTemplate(n);
            if (xSLTemplate == null) {
                throw this.styleError("Template " + (String)object + " has not been defined");
            }
        }
        object = null;
        if (this.hasChildNodes()) {
            NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
            object = new ParameterSet();
            while (nodeImpl != null) {
                if (nodeImpl instanceof XSLWithParam) {
                    XSLWithParam xSLWithParam = (XSLWithParam)nodeImpl;
                    ((ParameterSet)object).put(xSLWithParam.getVariableFingerprint(), xSLWithParam.getParamValue(context));
                }
                nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
            }
        }
        if (this.useTailRecursion) {
            if (object == null) {
                object = new ParameterSet();
            }
            context.setTailRecursion((ParameterSet)object);
        } else {
            Bindery bindery = context.getBindery();
            bindery.openStackFrame((ParameterSet)object);
            if (context.getController().isTracing()) {
                xSLTemplate.traceExpand(context);
            } else {
                xSLTemplate.expand(context);
            }
            bindery.closeStackFrame();
        }
    }
}

