/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.document.AbstractIndexableDocument;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLDocument
extends AbstractIndexableDocument
implements ParsableDocument {
    private boolean fromDOM = false;
    private static final int FROM_DOM = 3;
    private Document cDOM = null;
    private String MIMETYPE = "text/xml";

    public XMLDocument(String id) throws SDXException {
        this.setId(id);
    }

    public XMLDocument() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream openStream() throws SDXException {
        ByteArrayInputStream byteArrayInputStream;
        if (!this.fromDOM) return super.openStream();
        ByteArrayInputStream bIn = null;
        ByteArrayOutputStream bOut = null;
        try {
            try {
                bOut = new ByteArrayOutputStream();
                XMLSerializer xs = new XMLSerializer();
                xs.setOutputStream((OutputStream)bOut);
                DOMStreamer streamer = new DOMStreamer((XMLConsumer)xs);
                streamer.stream((Node)this.cDOM);
                byteArrayInputStream = bIn = new ByteArrayInputStream(bOut.toByteArray());
                Object var7_8 = null;
            }
            catch (SAXException e) {
                String[] args = new String[]{this.getId()};
                throw new SDXException(this.logger, 5005, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (bOut != null) {
                    bOut.close();
                }
                if (bIn == null) throw throwable;
                bIn.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new SDXException(this.logger, 219, null, e2);
            }
        }
        try {}
        catch (IOException e2) {
            throw new SDXException(this.logger, 219, null, e2);
        }
        if (bOut != null) {
            bOut.close();
        }
        if (bIn == null) return byteArrayInputStream;
        bIn.close();
        return byteArrayInputStream;
    }

    public void setContent(Document d) {
        this.cDOM = d;
        this.fromDOM = true;
    }

    public int getLength() {
        if (this.fromDOM) {
            return -1;
        }
        return super.getLength();
    }

    public void parse(Parser parser) throws SDXException {
        this.parse(parser, this.xmlConsumer);
    }

    public void startIndexing(Parser parser, XMLConsumer consumer) throws SDXException {
        Utilities.checkXmlConsumer(this.logger, consumer);
        super.resetFields();
        this.parse(parser, consumer);
    }

    public void parse(Parser parser, XMLConsumer consumer) throws SDXException {
        if (parser == null) {
            String[] args = new String[1];
            if (this.getURL() != null) {
                args[0] = this.getURL().toExternalForm();
            }
            throw new SDXException(this.logger, 5100, args, null);
        }
        Utilities.checkXmlConsumer(this.logger, consumer);
        try {
            parser.parse(this.getInputSource(), (ContentHandler)consumer);
        }
        catch (SAXException e) {
            String[] args = new String[2];
            if (this.getURL() != null) {
                args[0] = this.getURL().toExternalForm();
            }
            args[1] = e.getMessage();
            throw new SDXException(this.logger, 5101, args, e);
        }
        catch (IOException e) {
            String[] args = new String[2];
            if (this.getURL() != null) {
                args[0] = this.getURL().toExternalForm();
            }
            args[1] = e.getMessage();
            throw new SDXException(this.logger, 5101, args, e);
        }
    }

    public String getDocType() {
        return "xml";
    }

    public void setTransformedDocument(byte[] content) throws SDXException {
        if (content == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 5102, args, null);
        }
        XMLDocument doc = new XMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(this.logger);
        this.transformedDoc.setContent(content);
        this.setUpTransformedDocument();
    }

    public void setTransformedDocument(File file) throws SDXException {
        if (file == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 5102, args, null);
        }
        XMLDocument doc = new XMLDocument();
        this.transformedDoc = doc;
        this.transformedDoc.enableLogging(this.logger);
        this.transformedDoc.setContent(file);
        this.setUpTransformedDocument();
    }

    public String getMimeType() {
        return this.MIMETYPE;
    }

    public void addAdditionalSystemFields(org.apache.lucene.document.Document doc) {
    }
}

