/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.IndexableFieldProperty;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.documentbase.LuceneIndexParameters;
import fr.gouv.culture.sdx.documentbase.SDXDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.oai.LuceneDocumentBaseOAIHarvester;
import fr.gouv.culture.sdx.oai.LuceneDocumentBaseOAIRepository;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.FieldsDefinition;
import fr.gouv.culture.sdx.search.lucene.analysis.MetaAnalyzer;
import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.search.lucene.query.LuceneIndex;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.cocoon.ProcessingException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LuceneDocumentBase
extends SDXDocumentBase {
    protected Configuration configuration = null;
    protected LuceneIndex luceneSearchIndex;
    protected FieldsDefinition fieldsDef;
    public static final String FIELDS_DEFINITION = "fieldsDefinition";
    protected final String SEARCH_INDEX_DIRECTORY_NAME = "sdx-search-index";
    public static final String DBELEM_ATTRIBUTE_REMOTE_ACCESS = "remote-access";
    public static final String ELEMENT_NAME_FIELD_LIST = "fieldList";
    public static final String ELEMENT_NAME_LUCENE_SDX_INTERNAL_FIELDS = "luceneSDXInternalFields";

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        this.configuration = configuration;
        super.configure(configuration);
    }

    protected void configureDocumentBase(Configuration configuration) throws ConfigurationException {
        this.keepOriginalDocuments = configuration.getAttributeAsBoolean("keepOriginalDocuments", true);
        this.configureFieldList(configuration);
        this.configureSearchIndex();
    }

    protected void configureFieldList(Configuration configuration) throws ConfigurationException {
        try {
            Configuration fieldList = configuration.getChild(ELEMENT_NAME_FIELD_LIST, true);
            String ref = fieldList.getAttribute("ref", null);
            if (Utilities.checkString(ref)) {
                Hashtable appFieldLists = (Hashtable)this.props.get("appRepos");
                if (appFieldLists != null) {
                    this.fieldsDef = (FieldsDefinition)appFieldLists.get(ref);
                }
                this.fieldsDef = (FieldsDefinition)this.fieldsDef.clone();
                this.fieldsDef.configure(configuration);
                if (this.fieldsDef == null) {
                    String[] args = new String[]{ref};
                    throw new SDXException(this.logger, 42, args, null);
                }
            } else {
                this.fieldsDef = Utilities.configureFieldList(this.logger, configuration, this.props);
            }
            this.props.put(FIELDS_DEFINITION, this.fieldsDef);
        }
        catch (SDXException e) {
        }
        catch (ConfigurationException e) {
            Utilities.logException(this.logger, (Exception)((Object)e));
        }
    }

    protected void configureSearchIndex() throws ConfigurationException {
        try {
            String rmiHost = Utilities.getStringFromHashtable("rmiHost", this.props);
            Integer rmiPort = (Integer)this.props.get("rmiPort");
            String appId = Utilities.getStringFromHashtable("appId", this.props);
            String sdxSearchIndexPath = Utilities.getStringFromHashtable("dbDirPath", this.props) + "sdx-search-index" + File.separator;
            File sdxSearchIndexDir = Utilities.checkDirectory(sdxSearchIndexPath, this.logger);
            this.luceneSearchIndex = new LuceneIndex(sdxSearchIndexDir, rmiHost, rmiPort, appId, this.getId());
            this.luceneSearchIndex.enableLogging(this.logger);
            this.luceneSearchIndex.configure(this.configuration);
            MetaAnalyzer mAnalyzer = new MetaAnalyzer();
            mAnalyzer.enableLogging(this.logger);
            mAnalyzer.setUp(this.fieldsDef);
            this.luceneSearchIndex.setMetaAnalyzer(mAnalyzer);
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void configureOAIRepository(Configuration configuration) throws ConfigurationException {
        Configuration oaiRepoConf = configuration.getChild("oai-repository", false);
        if (oaiRepoConf != null) {
            LuceneDocumentBaseOAIRepository luceneOaiRepo = new LuceneDocumentBaseOAIRepository(this);
            luceneOaiRepo.enableLogging(this.logger);
            try {
                luceneOaiRepo.compose(this._manager);
                luceneOaiRepo.contextualize((Context)this.context);
            }
            catch (ComponentException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            luceneOaiRepo.setProperties(this.props);
            this.oaiRepo = luceneOaiRepo;
            this.oaiRepo.configure(oaiRepoConf);
        }
    }

    protected void configureOAIHarvester(Configuration configuration) throws ConfigurationException {
        Configuration oaiHarvConf = configuration.getChild("oai-harvester", false);
        if (oaiHarvConf != null) {
            this.oaiHarv = new LuceneDocumentBaseOAIHarvester(this);
            this.oaiHarv.enableLogging(this.logger);
            LuceneDocumentBaseOAIHarvester luceneHarvester = (LuceneDocumentBaseOAIHarvester)this.oaiHarv;
            try {
                luceneHarvester.compose(this._manager);
            }
            catch (ComponentException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            luceneHarvester.setProperties(this.props);
            this.oaiHarv.configure(oaiHarvConf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(Document[] docs, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        try {
            super.delete(docs, handler);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.luceneSearchIndex.optimize();
            this.luceneSearchIndex.writeLastModificationTimestampFile(true);
            throw throwable;
        }
        this.luceneSearchIndex.optimize();
        this.luceneSearchIndex.writeLastModificationTimestampFile(true);
    }

    protected IndexParameters setBaseParameters(IndexParameters params) {
        if (params != null && params instanceof LuceneIndexParameters) {
            this.setSearchIndexParameters((LuceneIndexParameters)params);
        }
        return super.setBaseParameters(params);
    }

    public Index getIndex() {
        return this.luceneSearchIndex;
    }

    protected void setSearchIndexParameters(LuceneIndexParameters params) {
        this.luceneSearchIndex.setParameters(params);
    }

    protected void addToSearchIndex(Object indexationDoc, boolean batchIndex) throws SDXException {
        this.luceneSearchIndex.writeDocument((org.apache.lucene.document.Document)indexationDoc, batchIndex);
    }

    protected void deleteFromSearchIndex(String docId) throws SDXException {
        this.luceneSearchIndex.deleteDocument(docId);
    }

    protected void compactSearchIndex() throws SDXException {
        this.luceneSearchIndex.mergeBatch();
    }

    protected Object getIndexationDocument(IndexableDocument doc, String storeDocId, String repoId, IndexParameters params) throws SDXException {
        org.apache.lucene.document.Field fId2;
        org.apache.lucene.document.Document lDoc = new org.apache.lucene.document.Document();
        float docBoost = doc.getBoost();
        lDoc.setBoost(docBoost);
        Enumeration fieldVals = doc.getFieldValues();
        while (fieldVals != null && fieldVals.hasMoreElements()) {
            int i;
            IndexableFieldProperty prop = (IndexableFieldProperty)fieldVals.nextElement();
            if (prop == null) continue;
            String fieldName = prop.getName();
            String[] fieldValues = prop.getValues();
            float fieldBoost = prop.getBoost();
            Field sdxF = this.fieldsDef.getField(fieldName);
            if (sdxF != null) {
                for (i = 0; i < fieldValues.length; ++i) {
                    org.apache.lucene.document.Field f = sdxF.getLuceneField(fieldValues[i]);
                    if (f == null) continue;
                    f.setBoost(fieldBoost);
                    lDoc.add(f);
                }
                continue;
            }
            for (i = 0; i < fieldValues.length; ++i) {
                if (Utilities.checkString(fieldValues[i])) {
                    // empty if block
                }
                lDoc.add(org.apache.lucene.document.Field.UnIndexed((String)fieldName, (String)fieldValues[i]));
            }
        }
        Utilities.checkDocument(this.logger, doc);
        org.apache.lucene.document.Field fId = null;
        if (Utilities.checkString(storeDocId)) {
            fId = org.apache.lucene.document.Field.Keyword((String)"sdxdocid", (String)storeDocId);
        }
        if (fId != null) {
            lDoc.add(fId);
        }
        if ((fId2 = org.apache.lucene.document.Field.Keyword((String)"sdxall", (String)"1")) != null) {
            lDoc.add(fId2);
        }
        org.apache.lucene.document.Field fId3 = null;
        String docbaseId = this.getId();
        if (Utilities.checkString(docbaseId)) {
            fId3 = org.apache.lucene.document.Field.Keyword((String)"sdxdbid", (String)docbaseId);
        }
        if (fId3 != null) {
            lDoc.add(fId3);
        }
        org.apache.lucene.document.Field fId4 = null;
        String appId = Utilities.getStringFromHashtable("appId", this.props);
        if (Utilities.checkString(appId)) {
            fId4 = org.apache.lucene.document.Field.Keyword((String)"sdxappid", (String)appId);
        }
        if (fId4 != null) {
            lDoc.add(fId4);
        }
        org.apache.lucene.document.Field fId5 = null;
        String doctype = doc.getDocType();
        if (Utilities.checkString(doctype)) {
            fId5 = org.apache.lucene.document.Field.Keyword((String)"sdxdoctype", (String)doctype);
        }
        if (fId5 != null) {
            lDoc.add(fId5);
        }
        org.apache.lucene.document.Field fId6 = null;
        long modDate = fr.gouv.culture.sdx.utils.Date.getUtcIso8601Date().getTime();
        modDate = Long.parseLong(params.getPipelineParams().getParameter("sdxDateMilliseconds", Long.toString(modDate)));
        fId6 = org.apache.lucene.document.Field.Keyword((String)"sdxmoddate", (String)DateField.timeToString(modDate));
        if (fId6 != null) {
            lDoc.add(fId6);
        }
        org.apache.lucene.document.Field fId7 = null;
        String length = Integer.toString(doc.getLength());
        if (Utilities.checkString(length)) {
            fId7 = org.apache.lucene.document.Field.Keyword((String)"sdxcontentlength", (String)length);
        }
        if (fId7 != null) {
            lDoc.add(fId7);
        }
        org.apache.lucene.document.Field fId8 = null;
        if (Utilities.checkString(repoId)) {
            fId8 = org.apache.lucene.document.Field.Keyword((String)"sdxrepoid", (String)repoId);
        }
        if (fId8 != null) {
            lDoc.add(fId8);
        }
        doc.addAdditionalSystemFields(lDoc);
        return lDoc;
    }

    public Date lastModificationDate() {
        return this.luceneSearchIndex.getLastModificationDate();
    }

    public Date creationDate() {
        return this.luceneSearchIndex.getCreationDate();
    }

    public void init() throws SDXException {
        super.init();
        this.luceneSearchIndex.init();
    }
}

