/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.oai.AbstractOAIMetadataFormat;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.pipeline.GenericPipeline;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BasicOAIMetadataFormat
extends AbstractOAIMetadataFormat
implements Composable {
    protected ComponentManager manager = null;
    protected Hashtable props = null;
    protected Pipeline pipe = null;
    protected Parameters concatenateFields = null;
    protected Hashtable aggregatedFields = null;
    protected String DEFAULT_CONCATENATED_FIELD_SEPARATOR = " ; ";
    protected final String ELEMENT_NAME_PIPELINE = "pipeline";
    protected final String ELEMENT_NAME_OAI_FIELDS = "oai-fields";
    protected final String ELEMENT_NAME_OAI_FIELD = "oai-field";
    protected final String ATTRIBUTE_NAME_NAME = "name";
    protected final String ATTRIBUTE_NAME_METADATA_PREFIX = "metadataPrefix";
    protected final String ATTRIBUTE_NAME_NAMESPACE = "namespace";
    protected final String ATTRIBUTE_NAME_SCHEMA_URL = "schemaUrl";
    protected final String ATTRIBUTE_NAME_ROOT_ELEMENT = "rootElement";
    protected final String ATTRIBUTE_NAME_SDXFIELD = "sdxField";
    protected final String ATTRIBUTE_NAME_REPEATED = "repeated";
    protected final String ATTRIBUTE_NAME_SEPARATOR = "separator";
    protected final String ATTRIBUTE_VALUE_CONCATENATE = "concatenate";

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.manager = componentManager;
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            this.formatName = configuration.getAttribute("name");
            this.prefix = configuration.getAttribute("metadataPrefix");
            this.namespace = configuration.getAttribute("namespace");
            this.schemaUrl = configuration.getAttribute("schemaUrl");
            this.rootElement = configuration.getAttribute("rootElement", "");
            this.configureFields(configuration);
            this.configurePipeline(configuration);
        }
    }

    protected void configureFields(Configuration configuration) throws ConfigurationException {
        Configuration[] oaiFieldsConf;
        if (configuration != null && (oaiFieldsConf = configuration.getChild("oai-fields", true).getChildren("oai-field")).length > 0) {
            this.metadataMappings = new Parameters();
            for (int i = 0; i < oaiFieldsConf.length; ++i) {
                Configuration oaiFieldConf = oaiFieldsConf[i];
                String sdxFieldName = oaiFieldConf.getAttribute("sdxField");
                String oaiFieldName = oaiFieldConf.getAttribute("name");
                String repeated = oaiFieldConf.getAttribute("repeated", "repeated");
                if ("concatenate".equals(repeated)) {
                    if (this.concatenateFields == null) {
                        this.concatenateFields = new Parameters();
                    }
                    String separator = oaiFieldConf.getAttribute("separator", this.DEFAULT_CONCATENATED_FIELD_SEPARATOR);
                    this.concatenateFields.setParameter(sdxFieldName, separator);
                }
                this.metadataMappings.setParameter(sdxFieldName, oaiFieldName);
            }
        }
    }

    protected void configurePipeline(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            Configuration pipeConf = configuration.getChild("pipeline", false);
            if (pipeConf != null && this.metadataMappings != null) {
                throw new ConfigurationException("both field mappings and a pipeline are not supported, only one or the other");
            }
            this.pipe = new GenericPipeline();
            this.pipe.enableLogging(this.logger);
            try {
                this.pipe.compose(this.manager);
            }
            catch (ComponentException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            this.pipe.setProperties(this.props);
            if (pipeConf != null) {
                this.pipe.configure(pipeConf);
            }
        }
    }

    public void sendElement(String origName, String value) throws SAXException {
        if (OAIUtilities.checkString(origName) && OAIUtilities.checkString(value)) {
            if (this.concatenateFields != null && this.concatenateFields.isParameter(origName)) {
                this.aggregateFields(origName, value);
            } else {
                this.prepareAndSendElement(origName, value);
            }
        }
    }

    protected void aggregateFields(String fieldName, String valueToConcat) {
        String aggreatedValue = null;
        if (this.aggregatedFields == null) {
            this.aggregatedFields = new Hashtable();
        } else {
            aggreatedValue = (String)this.aggregatedFields.get(fieldName);
        }
        String separator = this.concatenateFields.getParameter(fieldName, this.DEFAULT_CONCATENATED_FIELD_SEPARATOR);
        aggreatedValue = Utilities.checkString(aggreatedValue) ? aggreatedValue + separator + valueToConcat : valueToConcat;
        this.aggregatedFields.put(fieldName, aggreatedValue);
    }

    protected void sendAggregatedFields() throws SAXException {
        Enumeration keys;
        if (this.aggregatedFields != null && (keys = this.aggregatedFields.keys()) != null) {
            while (keys.hasMoreElements()) {
                String fieldValue;
                String fieldName = (String)keys.nextElement();
                if (!Utilities.checkString(fieldName) || !Utilities.checkString(fieldValue = (String)this.aggregatedFields.remove(fieldName))) continue;
                this.prepareAndSendElement(fieldName, fieldValue);
            }
            this.aggregatedFields = null;
        }
    }

    public void endMetadataFormatRootElement() throws SAXException {
        this.sendAggregatedFields();
        super.endMetadataFormatRootElement();
    }

    public Pipeline getPipeline() {
        return this.pipe;
    }

    public Pipeline getAddRootAttributePipe() {
        return new AddRootAttributePipe(this.namespace, this.schemaUrl);
    }

    private class AddRootAttributePipe
    extends GenericPipeline {
        int elementCount = 0;
        String schemaLocVal = "";

        public AddRootAttributePipe(String ns, String schemaLoc) {
            this.schemaLocVal = ns + " " + schemaLoc;
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            ++this.elementCount;
            if (this.elementCount == 1) {
                AttributesImpl new_atts = new AttributesImpl(a);
                if (new_atts.getIndex("xmlns:xsi") < 0) {
                    new_atts.addAttribute("", "xmlns:xsi", "xmlns:xsi", "CDATA", "http://www.w3.org/2001/XMLSchema-instance");
                }
                if (new_atts.getIndex("xsi:schemaLocation") < 0) {
                    new_atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi:schemaLocation", "CDATA", this.schemaLocVal);
                }
                super.startElement(uri, loc, raw, (Attributes)new_atts);
            } else {
                super.startElement(uri, loc, raw, a);
            }
        }
    }
}

