/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.pipeline.TagFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementFilter
extends TagFilter {
    protected boolean withinFilteredElement;
    protected int filteredCount;

    public ElementFilter() {
        this.withinFilteredElement = !this._send;
        this.filteredCount = 0;
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.setCurrentElementProperties(uri, loc, raw, a);
        boolean send = this.shouldSendElementEvent(uri, loc, raw, a);
        if (send == this._send) {
            ++this.filteredCount;
        }
        if (send && this.xmlConsumer != null) {
            this.xmlConsumer.startElement(uri, loc, raw, a);
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        boolean send = this.shouldSendElementEvent(this.c_uri, this.c_loc, this.c_raw, this.c_atts);
        if (send && this.xmlConsumer != null) {
            this.xmlConsumer.characters(c, start, len);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        boolean send = this.shouldSendElementEvent(uri, loc, raw, this.c_atts);
        if (send == this._send) {
            --this.filteredCount;
            if (this.filteredCount == 0) {
                this.withinFilteredElement = false;
            }
        }
        if (send && this.xmlConsumer != null) {
            this.xmlConsumer.endElement(uri, loc, raw);
        }
        this.resetCurrentElementProperties();
    }

    protected boolean shouldSendElementEvent(String uri, String loc, String raw, Attributes a) {
        boolean send = super.shouldSendElementEvent(uri, loc, raw, a);
        return this.withinFilteredElement(send);
    }

    protected boolean withinFilteredElement(boolean shouldSendElementEvent) {
        boolean send = shouldSendElementEvent;
        if (shouldSendElementEvent == this._send) {
            this.withinFilteredElement = true;
        }
        if (this.withinFilteredElement || this.filteredCount > 0) {
            send = this._send;
        }
        return send;
    }
}

