/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.xslt.XSLTProcessor;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.URLFactorySourceResolver;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLTTransformation
extends AbstractTransformation {
    private XSLTProcessor xsltProcessor;
    private ModifiableSource inputSource;
    private TransformerHandler transformerHandler;

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            super.configure(configuration);
            String src = configuration.getAttribute("src");
            Utilities.checkConfAttributeValue("src", src, configuration.getLocation());
            File srcFile = null;
            try {
                srcFile = Utilities.resolveFile(null, configuration.getLocation(), this.props, src, false);
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            src = srcFile.toURL().toExternalForm();
            if (this.manager == null) {
                SDXException sdxE = new SDXException(null, 221, null, null);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
            }
            XSLTProcessor xsltProcessor = (XSLTProcessor)this.manager.lookup("org.apache.cocoon.components.xslt.XSLTProcessor");
            URLFactorySourceResolver resolver = new URLFactorySourceResolver(this.manager);
            this.xsltProcessor = xsltProcessor;
            this.xsltProcessor.setSourceResolver((SourceResolver)resolver);
            this.inputSource = (ModifiableSource)resolver.resolve(src);
        }
        catch (ProcessingException e) {
            Utilities.logException(this.logger, (Exception)((Object)e));
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        catch (SAXException e) {
            Utilities.logException(this.logger, e);
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        catch (IOException e) {
            Utilities.logException(this.logger, e);
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        catch (ComponentException e) {
            Utilities.logException(this.logger, (Exception)((Object)e));
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        try {
            Utilities.checkXmlConsumer(this.logger, consumer);
        }
        catch (SDXException e) {
            // empty catch block
        }
        this.inputSource.refresh();
        try {
            this.transformerHandler = this.xsltProcessor.getTransformerHandler((Source)this.inputSource);
            if (this.getParameters() != null) {
                Transformer trans = this.transformerHandler.getTransformer();
                trans.clearParameters();
                Parameters params = this.getParameters();
                String[] paramNames = params.getNames();
                for (int i = 0; i < paramNames.length; ++i) {
                    try {
                        trans.setParameter(paramNames[i], params.getParameter(paramNames[i]));
                        continue;
                    }
                    catch (ParameterException e) {
                        Utilities.logException(this.logger, (Exception)((Object)e));
                    }
                }
            }
        }
        catch (ProcessingException e) {
            Utilities.logException(this.logger, (Exception)((Object)e));
        }
        super.setContentHandler((ContentHandler)this.transformerHandler);
        super.setLexicalHandler((LexicalHandler)this.transformerHandler);
        if (this.transformerHandler instanceof LogEnabled) {
            ((LogEnabled)this.transformerHandler).enableLogging(this.logger);
        }
        SAXResult result = new SAXResult((ContentHandler)consumer);
        result.setLexicalHandler((LexicalHandler)consumer);
        if (this.transformerHandler != null) {
            this.transformerHandler.setResult(result);
        }
        this.xmlConsumer = consumer;
    }

    public void startDocument() throws SAXException {
        this.setConsumer(this.xmlConsumer);
        super.startDocument();
    }
}

