/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.xml.XMLConsumer;

public abstract class AbstractDatabaseBackedRepository
extends DatabaseBacked
implements Repository {
    protected Logger logger;
    protected boolean isDefault;
    private final String ATTRIBUTE_READ_ONLY = "read-only";
    protected final String DEFAULT_ENCODING = "UTF-8";

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public String getId() {
        return this.id;
    }

    protected void loadBaseConfiguration(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        super.configure(configuration);
        if (!Utilities.checkString(this.id)) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(this.logger, 18, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
    }

    public void releaseConnection(RepositoryConnection c) throws SDXException {
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void delete(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        this.checkConnection(c);
    }

    public void add(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        this.checkConnection(c);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        encoding = this.checkEncoding(encoding);
        this.checkConnection(c);
        return null;
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        Utilities.checkOutputStream(this.logger, os);
        this.checkConnection(c);
    }

    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        Utilities.checkXmlConsumer(this.logger, consumer);
        this.checkConnection(c);
    }

    public void setIsDefault(boolean b) {
        this.isDefault = b;
    }

    protected String checkEncoding(String encoding) throws SDXException {
        String defaultEncoding = "UTF-8";
        if (Utilities.checkString(encoding)) {
            try {
                defaultEncoding.getBytes(encoding);
                return encoding;
            }
            catch (UnsupportedEncodingException e) {
                Utilities.logException(this.logger, e);
                try {
                    defaultEncoding.getBytes(defaultEncoding);
                    Utilities.logInfo(this.logger, "using the default encoding: " + defaultEncoding);
                    return defaultEncoding;
                }
                catch (UnsupportedEncodingException e1) {
                    String[] args = new String[]{defaultEncoding, e1.getMessage()};
                    throw new SDXException(this.logger, 217, args, null);
                }
            }
        }
        return defaultEncoding;
    }

    public void checkConnection(RepositoryConnection c) throws SDXException {
        if (c == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 3005, args, null);
        }
    }

    public void optimize() throws SDXException {
        this.database.optimize();
    }

    public boolean exists(String id, RepositoryConnection conn) {
        return this.database.entityExists(id);
    }
}

