/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractDatabaseBackedRepository;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.repository.URLRepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.ContentHandler;

public class URLRepository
extends AbstractDatabaseBackedRepository {
    private boolean checkOnGet = false;
    private boolean useCache = false;
    private URL baseURL = null;
    private Repository cacheRepository = null;
    private static String URL_PROPERTY = "url";
    private static String TIME_PROPERTY = "time";
    private static String IS_RELATIVE_PROPERTY = "relative";
    private final String ATTRIBUTE_BASE = "base";
    private final String ELEMENT_CACHE = "cache";
    private final String ELEMENT_REPOSITORY = "repository";
    private final String ATTRIBUTE_CHECK = "check";
    private String ATTRIBUTE_VALUE_ON_GET = "onGet";
    private Boolean pathIsRelative;

    public void releaseConnection(RepositoryConnection c) throws SDXException {
        super.releaseConnection(c);
        if (this.useCache) {
            this.cacheRepository.releaseConnection(c);
        }
    }

    public RepositoryConnection getConnection() throws SDXException {
        if (this.useCache) {
            return this.cacheRepository.getConnection();
        }
        URLRepositoryConnection conn = new URLRepositoryConnection();
        conn.enableLogging(this.logger);
        return conn;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        try {
            Configuration cacheConf;
            this.loadBaseConfiguration(configuration);
            String base = configuration.getAttribute("base", null);
            if (Utilities.checkString(base)) {
                if (base.startsWith("http://")) {
                    if (!base.endsWith("/")) {
                        base = base + "/";
                    }
                    this.baseURL = new URL(base);
                } else {
                    File baseFile = Utilities.resolveFile(null, configuration.getLocation(), this.props, base, false);
                    this.baseURL = baseFile.toURL();
                }
            }
            if ((cacheConf = configuration.getChild("cache", false)) != null) {
                Configuration cacheRepoConf;
                this.useCache = true;
                String check = cacheConf.getAttribute("check", this.ATTRIBUTE_VALUE_ON_GET);
                if (check.equalsIgnoreCase(this.ATTRIBUTE_VALUE_ON_GET)) {
                    this.checkOnGet = true;
                }
                if ((cacheRepoConf = cacheConf.getChild("repository", false)) == null) {
                    String[] args = new String[]{cacheConf.getLocation()};
                    SDXException sdxE = new SDXException(this.logger, 20, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
                }
                String ref = cacheRepoConf.getAttribute("ref", null);
                if (Utilities.checkString(ref)) {
                    Hashtable appRepos = (Hashtable)this.props.get("appRepos");
                    if (appRepos != null) {
                        this.cacheRepository = (Repository)appRepos.get(ref);
                    }
                    if (this.cacheRepository == null) {
                        String[] args = new String[]{ref};
                        throw new SDXException(this.logger, 29, args, null);
                    }
                } else {
                    this.cacheRepository = Utilities.createRepository(cacheRepoConf, this._manager, this.props, this.logger);
                }
            }
        }
        catch (ConfigurationException e) {
            Utilities.logException(this.logger, (Exception)((Object)e));
            throw e;
        }
        catch (MalformedURLException e) {
            Utilities.logException(this.logger, e);
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
    }

    public void init() throws SDXException {
        super.init();
    }

    public long size() throws SDXException {
        return this.database.size();
    }

    public long size(int type) throws SDXException {
        return this.database.size();
    }

    public void lists(ContentHandler hdl) throws SDXException {
    }

    public synchronized void add(Document doc, RepositoryConnection c) throws SDXException {
        super.add(doc, c);
        String docId = doc.getId();
        String docUrl = this.getURL(doc);
        long now = new Date().getTime();
        if (Utilities.checkString(docUrl)) {
            if (this.useCache) {
                this.cacheRepository.add(doc, c);
            }
            DatabaseEntity de = new DatabaseEntity(docId);
            de.addProperty(URL_PROPERTY, docUrl);
            de.addProperty(TIME_PROPERTY, new Long(now).toString());
            de.addProperty(IS_RELATIVE_PROPERTY, this.pathIsRelative.toString());
            this.database.update(de);
        }
    }

    public synchronized void empty() throws SDXException {
        if (this.useCache) {
            this.cacheRepository.empty();
        }
        this.database.empty();
    }

    public synchronized void delete(Document doc, RepositoryConnection c) throws SDXException {
        super.delete(doc, c);
        if (this.useCache) {
            this.cacheRepository.delete(doc, c);
        }
        this.database.delete(new DatabaseEntity(doc.getId()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        super.toSAX(doc, consumer, c);
        Parser parser = null;
        try {
            try {
                doc.setContent(this.openStream(doc, null, c));
                parser = (Parser)this._manager.lookup(Parser.ROLE);
                doc.parse(parser, consumer);
            }
            catch (ComponentException e) {
                String[] args = new String[]{e.getMessage()};
                SDXException sdxE = new SDXException(null, 2001, args, e);
                String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
                throw new SDXException(this.logger, 3001, args2, sdxE);
            }
            Object var10_5 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            if (parser == null) throw throwable;
            this._manager.release(parser);
            throw throwable;
        }
        this._manager.release((Component)parser);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        super.openStream(doc, encoding, c);
        return this.openStream(doc);
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        super.get(doc, os, c);
        try {
            InputStream is = this.openStream(doc);
            IOUtil.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3001, args, e);
        }
    }

    private URL getURL(Boolean isRelative, String u) throws MalformedURLException, IOException {
        if (isRelative.booleanValue()) {
            return new URL(this.baseURL, u);
        }
        return new URL(u);
    }

    private InputStream openStream(Document doc) throws SDXException {
        DatabaseEntity de = this.database.getEntity(doc.getId());
        if (de == null) {
            String[] args = new String[]{doc.getId(), this.getId()};
            throw new SDXException(this.logger, 3002, args, null);
        }
        if (this.useCache) {
            RepositoryConnection conn = this.cacheRepository.getConnection();
            InputStream is = this.cacheRepository.openStream(doc, null, conn);
            this.cacheRepository.releaseConnection(conn);
            return is;
        }
        try {
            URL docURL = this.getURL(Boolean.valueOf(de.getProperty(IS_RELATIVE_PROPERTY)), de.getProperty(URL_PROPERTY));
            return docURL.openStream();
        }
        catch (MalformedURLException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3001, args, e);
        }
        catch (IOException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3001, args, e);
        }
    }

    private String getURL(Document doc) throws SDXException {
        URL docURL = doc.getURL();
        if (docURL != null) {
            if (this.baseURL == null) {
                this.pathIsRelative = new Boolean(false);
                return docURL.toExternalForm();
            }
            return this.compareURL(docURL);
        }
        return null;
    }

    private String compareURL(URL docURL) {
        String rootFilePath = docURL.toExternalForm().substring(0, this.baseURL.toExternalForm().length());
        if (rootFilePath.equals(this.baseURL.toExternalForm())) {
            this.pathIsRelative = new Boolean(true);
            return docURL.toExternalForm().substring(this.baseURL.toExternalForm().length());
        }
        this.pathIsRelative = new Boolean(false);
        return docURL.toExternalForm();
    }

    public void optimize() throws SDXException {
        super.optimize();
        if (this.useCache) {
            this.cacheRepository.optimize();
        }
    }
}

