/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.filter;

import fr.gouv.culture.sdx.search.lucene.filter.AbstractFilter;
import fr.gouv.culture.sdx.search.lucene.filter.FilterCriteria;
import fr.gouv.culture.sdx.utils.Bits;
import java.util.BitSet;
import java.util.Vector;
import org.apache.cocoon.ProcessingException;
import org.apache.lucene.index.IndexReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Filter
extends AbstractFilter {
    public static final int BOOLEAN_OPERATOR_AND = 1;
    public static final int BOOLEAN_OPERATOR_OR = 0;
    public static final int BOOLEAN_OPERATOR_NOT = 2;
    private int operator;
    private Vector children = new Vector();
    private BitSet bits;

    public Filter() {
        this.setUp(-1);
    }

    public Filter(int operator) {
        this.operator = operator;
    }

    public void setUp(int operator) {
        switch (operator) {
            case 0: 
            case 1: 
            case 2: {
                this.operator = operator;
                break;
            }
            default: {
                this.operator = 1;
            }
        }
    }

    public void add(FilterCriteria criteria) {
        if (criteria != null) {
            this.children.add(criteria);
        }
    }

    public BitSet bits(IndexReader r) {
        block5: for (int i = 0; i < this.children.size(); ++i) {
            if (i == 0) {
                this.bits = ((FilterCriteria)this.children.get(i)).bits(r);
                continue;
            }
            switch (this.operator) {
                case 1: {
                    this.bits.and(((FilterCriteria)this.children.get(i)).bits(r));
                    continue block5;
                }
                case 0: {
                    this.bits.or(((FilterCriteria)this.children.get(i)).bits(r));
                    continue block5;
                }
                case 2: {
                    BitSet tempBits = new BitSet(this.bits.size());
                    tempBits.xor(((FilterCriteria)this.children.get(i)).bits(r));
                    this.bits.and(tempBits);
                }
            }
        }
        return this.bits;
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "filter";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "linear");
        switch (this.operator) {
            case 1: {
                atts.addAttribute("", "operator", "operator", "CDATA", "and");
                break;
            }
            case 0: {
                atts.addAttribute("", "operator", "operator", "CDATA", "or");
                break;
            }
            case 2: {
                atts.addAttribute("", "operator", "operator", "CDATA", "not");
            }
        }
        if (this.bits != null) {
            atts.addAttribute("", "nb", "nb", "CDATA", String.valueOf(Bits.countBits(this.bits)));
        }
        hdl.startElement(sdxNsUri, localName, qName, atts);
        for (int i = 0; i < this.children.size(); ++i) {
            ((FilterCriteria)this.children.get(i)).toSAX(hdl);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }
}

