/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.filter.AbstractFilter;
import fr.gouv.culture.sdx.search.lucene.query.ComplexQuery;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.SortSpecification;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Searcher;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractQuery
extends SdxObjectImpl
implements Query,
LogEnabled {
    protected org.apache.lucene.search.Query luceneQuery;
    protected String queryText;
    protected SearchLocations searchLocations;
    protected Results baseResults;
    protected Query baseQuery;
    protected int baseOperator;
    protected SortSpecification sortSpecification;
    protected AbstractFilter filter;

    public void setUp(SearchLocations sLocs, org.apache.lucene.search.Query lquery) throws SDXException {
        this.setSearchLocations(sLocs);
        if (lquery != null) {
            this.luceneQuery = lquery;
        }
    }

    public void setLuceneQuery(org.apache.lucene.search.Query lquery) {
        if (lquery != null) {
            this.luceneQuery = lquery;
        }
    }

    public org.apache.lucene.search.Query getLuceneQuery() {
        return this.luceneQuery;
    }

    public Results execute() throws SDXException {
        this.filter = this.prepare();
        if (this.searchLocations == null) {
            throw new SDXException(null, 4000, null, null);
        }
        Searcher searcher = this.searchLocations.getSearcher();
        if (searcher == null) {
            throw new SDXException(this.logger, 4103, null, null);
        }
        if (this.baseQuery != null && !(this instanceof ComplexQuery)) {
            BooleanQuery newQuery = new BooleanQuery();
            switch (this.baseOperator) {
                case 0: {
                    newQuery.add(this.luceneQuery, false, false);
                    newQuery.add(this.baseQuery.getLuceneQuery(), false, false);
                    break;
                }
                case 2: {
                    newQuery.add(this.luceneQuery, false, true);
                    newQuery.add(this.baseQuery.getLuceneQuery(), true, false);
                    break;
                }
                default: {
                    this.baseOperator = 1;
                    newQuery.add(this.luceneQuery, true, false);
                    newQuery.add(this.baseQuery.getLuceneQuery(), true, false);
                }
            }
            this.luceneQuery = newQuery;
        }
        try {
            Hits searchHits = this.filter == null ? searcher.search(this.luceneQuery) : searcher.search(this.luceneQuery, (Filter)this.filter);
            Results results = new Results();
            results.enableLogging(this.logger);
            results.setUp(this.searchLocations, searchHits, this.sortSpecification, this);
            return results;
        }
        catch (IOException e) {
            String[] args = new String[3];
            if (this.luceneQuery != null) {
                args[0] = this.luceneQuery.toString();
            }
            args[1] = searcher.toString();
            args[2] = e.getMessage();
            throw new SDXException(this.logger, 4104, args, e);
        }
    }

    public static int getOperator(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equalsIgnoreCase("0")) {
            return 0;
        }
        if (str.equalsIgnoreCase("1")) {
            return 1;
        }
        if (str.equalsIgnoreCase("2")) {
            return 2;
        }
        if (str.equalsIgnoreCase("and")) {
            return 1;
        }
        if (str.equalsIgnoreCase("et")) {
            return 1;
        }
        if (str.equalsIgnoreCase("or")) {
            return 0;
        }
        if (str.equalsIgnoreCase("ou")) {
            return 0;
        }
        if (str.equalsIgnoreCase("not")) {
            return 2;
        }
        if (str.equalsIgnoreCase("sauf")) {
            return 2;
        }
        return 1;
    }

    public void addBaseQuery(Results results, int operator) {
        this.baseResults = results;
        this.baseOperator = operator;
        if (results != null) {
            this.baseQuery = results.getQuery();
        }
    }

    public void addBaseQuery(Query query, int operator) {
        if (query != null) {
            this.baseQuery = query;
            this.baseOperator = operator;
        }
    }

    public void addSortSpecification(SortSpecification ss) {
        this.sortSpecification = ss;
    }

    public void addFilter(AbstractFilter filter) {
        this.filter = filter;
    }

    public AbstractFilter prepare() {
        return this.filter;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected AttributesImpl addAttributesLucene(AttributesImpl atts) throws SAXException, ProcessingException {
        atts.addAttribute("", "engine", "engine", "CDATA", "lucene");
        if (this.luceneQuery != null && this.searchLocations != null) {
            try {
                String fieldName = null;
                String luceneQueryString = null;
                Field field = this.searchLocations.getDefaultField();
                if (field != null) {
                    fieldName = field.getCode();
                }
                if (fieldName != null) {
                    luceneQueryString = this.luceneQuery.toString(fieldName);
                }
                if (luceneQueryString != null) {
                    atts.addAttribute("", "luceneQuery", "luceneQuery", "CDATA", luceneQueryString);
                    atts.addAttribute("", "escapedLuceneQuery", "escapedLuceneQuery", "CDATA", Utilities.encodeURL(luceneQueryString, this.encoding));
                }
            }
            catch (SDXException sdxE) {
                throw new SAXException(sdxE.getMessage(), sdxE);
            }
        }
        return atts;
    }

    protected AttributesImpl addAttributesText(AttributesImpl atts) throws SAXException, ProcessingException {
        if (this.queryText != null) {
            atts.addAttribute("", "text", "text", "CDATA", this.queryText);
            atts.addAttribute("", "escapedText", "escapedText", "CDATA", Utilities.encodeURL(this.queryText, this.encoding));
        }
        return atts;
    }

    public abstract void toSAX(ContentHandler var1) throws SAXException, ProcessingException;

    protected void setSearchLocations(SearchLocations sLocs) throws SDXException {
        if (sLocs == null) {
            throw new SDXException(null, 4000, null, null);
        }
        this.searchLocations = sLocs;
    }

    public void setUp() {
    }

    public SearchLocations getSearchLocations() {
        return this.searchLocations;
    }
}

