/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.query.AbstractQuery;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.queryparser.ParseException;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.search.lucene.queryparser.TokenMgrError;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.cocoon.ProcessingException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleQuery
extends AbstractQuery {
    private int op;

    public void setUp(SearchLocations sLocs, String defaultField, String q) throws SDXException {
        this.setUp(sLocs, defaultField, q, 0);
    }

    public void setUp(SearchLocations sLocs, String defaultField, String q, int operator) throws SDXException {
        this.op = operator;
        super.setSearchLocations(sLocs);
        if (q == null) {
            throw new SDXException(null, 4100, null, null);
        }
        Field df = null;
        if (!Utilities.checkString(defaultField) && (df = this.searchLocations.getDefaultField()) != null) {
            defaultField = df.getCode();
        }
        this.queryText = q;
        try {
            QueryParser qp = this.searchLocations.getQueryParser();
            if (qp == null) {
                throw new SDXException(this.logger, 4109, null, null);
            }
            if (df == null) {
                df = this.searchLocations.getField(defaultField);
            }
            Analyzer fa = null;
            if (df != null) {
                fa = df.getAnalyzer();
            }
            if (fa != null) {
                qp.setUp(defaultField, fa);
                qp.setOperator(operator);
                this.luceneQuery = qp.parse(q);
            }
        }
        catch (ParseException e) {
            String[] args = new String[]{q};
            throw new SDXException(this.logger, 4101, args, e);
        }
        catch (TokenMgrError e) {
            String[] args = new String[]{q};
            throw new SDXException(this.logger, 4101, args, e);
        }
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "query";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "simple");
        atts = super.addAttributesLucene(atts);
        atts = super.addAttributesText(atts);
        switch (this.op) {
            case 1: {
                atts.addAttribute("", "op", "op", "CDATA", "and");
                break;
            }
            case 0: {
                atts.addAttribute("", "op", "op", "CDATA", "or");
                break;
            }
            case 2: {
                atts.addAttribute("", "op", "op", "CDATA", "not");
            }
        }
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (this.baseQuery != null) {
            String bqLocalName = "baseQuery";
            String bqQName = sdxNsPrefix + ":" + bqLocalName;
            AttributesImpl emptyAtts = new AttributesImpl();
            hdl.startElement(sdxNsUri, bqLocalName, bqQName, emptyAtts);
            this.baseQuery.toSAX(hdl);
            hdl.endElement(sdxNsUri, bqLocalName, bqQName);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }
}

