/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import java.io.File;
import java.util.Hashtable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class DatabaseBacked
extends SdxObjectImpl
implements Composable {
    protected final String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.utils.database.";
    protected final String DEFAULT_DATABASE_TYPE = "fr.gouv.culture.sdx.utils.database.HSQLDatabase";
    protected final String CLASS_NAME_SUFFIX = "Database";
    public static final String ELEMENT_NAME_DATABASE = "database";
    protected final String ATTRIBUTE_ID = "id";
    public String DATABASE_DIR_NAME = "sdx-database";
    protected ComponentManager _manager = null;
    protected Hashtable props = null;
    protected Database database = null;
    protected String dbPath = null;
    protected File dbLocation = null;
    protected String id = null;
    protected Configuration databaseConf = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) throws SDXException {
        this.id = id;
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        this._manager = componentManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        this.id = configuration.getAttribute("id", this.id);
        Configuration defaultDatabaseConf = (Configuration)this.props.get("defaultDatabaseType");
        if (defaultDatabaseConf == null) {
            defaultDatabaseConf = new DefaultConfiguration("", "");
        }
        this.databaseConf = configuration.getChild(ELEMENT_NAME_DATABASE, false);
        if (this.databaseConf == null && defaultDatabaseConf != null) {
            this.databaseConf = defaultDatabaseConf;
        }
        try {
            String dbType;
            String dbClassName = dbType = this.databaseConf.getAttribute("type", "fr.gouv.culture.sdx.utils.database.HSQLDatabase");
            Class<?> dbClass = null;
            try {
                dbClass = Class.forName(dbClassName);
            }
            catch (ClassNotFoundException e) {
                Utilities.logWarn(this.logger, e.getMessage(), null);
                dbClassName = "fr.gouv.culture.sdx.utils.database." + dbType.substring(0, 1).toUpperCase() + dbType.substring(1, dbType.length()) + "Database";
                dbClass = Class.forName(dbClassName);
            }
            try {
                this.database = (Database)dbClass.newInstance();
            }
            catch (ClassCastException e) {
                String[] args = new String[]{"Database", dbClass.getName(), dbType};
                throw new SDXException(this.logger, 10, args, null);
            }
            this.database.enableLogging(this.logger);
            this.database.compose(this._manager);
            String dbDirName = this.database.getDatabaseDirectoryName();
            if (Utilities.checkString(dbDirName)) {
                this.DATABASE_DIR_NAME = dbDirName;
            }
            this.database.setProperties(this.props);
            this.database.setId(this.id);
            this.database.configure(this.databaseConf);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        catch (ComponentException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void init() throws SDXException {
        if (this.database != null) {
            this.database.init();
        }
    }

    public Database getDatabase() {
        return this.database;
    }
}

