/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.rdbms.hsql;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class HSQLDB
extends SdxObjectImpl {
    protected final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    protected final String PROTOCOL_PREFIX = "jdbc:hsqldb:";
    protected String dbDirPath = null;
    protected String tableName = null;
    protected String tableCreationQuery = null;
    private Connection conn;

    public HSQLDB() throws ClassNotFoundException {
        Class.forName("org.hsqldb.jdbcDriver");
    }

    public void setDbDirPath(String dbDirPath) throws SDXException {
        this.dbDirPath = dbDirPath;
        this.getSQLConnection();
    }

    public String getDbDirPath() {
        return this.dbDirPath;
    }

    public synchronized Connection getSQLConnection() throws SDXException {
        if (this.conn != null) {
            return this.conn;
        }
        try {
            Connection conn;
            if (!Utilities.checkString(this.dbDirPath)) {
                throw new SQLException("the db directory path for this db instance is not set");
            }
            this.conn = conn = DriverManager.getConnection("jdbc:hsqldb:" + this.dbDirPath, "sa", "");
            return conn;
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dbDirPath};
            throw new SDXException(this.logger, 113, args, e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

